/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.ui.integration;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.flux.client.IChannelListener;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.core.Activator;
import org.eclipse.flux.core.ChannelSwitcher;
import org.eclipse.flux.core.IRepositoryListener;
import org.eclipse.flux.core.LiveEditCoordinator;
import org.eclipse.flux.core.Repository;
import org.eclipse.flux.ui.integration.CloudProjectDecorator;
import org.eclipse.flux.ui.integration.handlers.LiveEditConnector;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;

public class UiStartup
implements IStartup {
    private static long WAIT_TIME_PERIOD = 100L;

    public void earlyStartup() {
        ChannelSwitcher channelSwitcher = Activator.getDefault().getChannelSwitcher();
        MessageConnector messagingConnector = Activator.getDefault().getMessageConnector();
        if (messagingConnector != null) {
            UiChannelListener uiChannelListener = new UiChannelListener();
            String userChannel = channelSwitcher.getChannel();
            while (userChannel == null) {
                try {
                    Thread.sleep(WAIT_TIME_PERIOD);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                userChannel = channelSwitcher.getChannel();
            }
            uiChannelListener.connected(userChannel);
            messagingConnector.addChannelListener((IChannelListener)uiChannelListener);
        }
    }

    private static void updateProjectLabel(final IProject project) {
        final CloudProjectDecorator projectDecorator = CloudProjectDecorator.getInstance();
        if (projectDecorator != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    projectDecorator.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)projectDecorator, (Object)project));
                }
            });
        }
    }

    private class UiChannelListener
    implements IChannelListener {
        private LiveEditConnector liveEditConnector = null;
        private IRepositoryListener repositoryListener = new IRepositoryListener(){

            public void projectDisconnected(IProject project) {
                UiStartup.updateProjectLabel(project);
            }

            public void projectConnected(IProject project) {
                UiStartup.updateProjectLabel(project);
            }

            public void resourceChanged(IResource resource) {
            }
        };

        private UiChannelListener() {
        }

        public void connected(String userChannel) {
            Repository repository = Activator.getDefault().getRepository();
            repository.addRepositoryListener(this.repositoryListener);
            if (Boolean.getBoolean("flux-eclipse-editor-connect")) {
                LiveEditCoordinator liveEditCoordinator = Activator.getDefault().getLiveEditCoordinator();
                this.liveEditConnector = new LiveEditConnector(liveEditCoordinator, repository);
            }
        }

        public void disconnected(String userChannel) {
            Activator.getDefault().getRepository().removeRepositoryListener(this.repositoryListener);
            if (this.liveEditConnector != null) {
                this.liveEditConnector.dispose();
            }
        }
    }
}

