/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.ui.integration.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.flux.core.ConnectedProject;
import org.eclipse.flux.core.ILiveEditConnector;
import org.eclipse.flux.core.IRepositoryListener;
import org.eclipse.flux.core.LiveEditCoordinator;
import org.eclipse.flux.core.Repository;
import org.eclipse.flux.ui.integration.handlers.PendingLiveEditStartedResponse;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class LiveEditConnector {
    private static final String LIVE_EDIT_CONNECTOR_ID = "UI-Editor-Live-Edit-Connector";
    private IDocumentListener documentListener;
    private IFileBufferListener fileBufferListener;
    private IRepositoryListener repositoryListener;
    private IResourceChangeListener workspaceListener;
    private IPartListener2 partListener;
    private ILiveEditConnector liveEditConnector;
    private Repository repository;
    private ConcurrentMap<IDocument, String> resourceMappings;
    private ConcurrentMap<String, IDocument> documentMappings;
    private LiveEditCoordinator liveEditCoordinator;
    private ConcurrentHashMap<String, PendingLiveEditStartedResponse> pendingLiveEditStartedResponses;

    public LiveEditConnector(LiveEditCoordinator liveEditCoordinator, Repository repository) {
        this.liveEditCoordinator = liveEditCoordinator;
        this.repository = repository;
        this.resourceMappings = new ConcurrentHashMap<IDocument, String>();
        this.documentMappings = new ConcurrentHashMap<String, IDocument>();
        this.pendingLiveEditStartedResponses = new ConcurrentHashMap();
        this.documentListener = new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                LiveEditConnector.this.sendModelChangedMessage(event);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        };
        this.fileBufferListener = new IFileBufferListener(){

            public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
            }

            public void underlyingFileDeleted(IFileBuffer buffer) {
            }

            public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
            }

            public void stateChanging(IFileBuffer buffer) {
            }

            public void stateChangeFailed(IFileBuffer buffer) {
            }

            public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            }

            public void bufferDisposed(IFileBuffer buffer) {
            }

            public void bufferCreated(IFileBuffer buffer) {
            }

            public void bufferContentReplaced(IFileBuffer buffer) {
                IPath path = buffer.getLocation();
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot root = workspace.getRoot();
                IResource resource = root.findMember(path);
                if (resource != null) {
                    Repository repository;
                    IProject project = resource.getProject();
                    String resourcePath = resource.getProjectRelativePath().toString();
                    String fullPath = String.valueOf(project.getName()) + "/" + resourcePath;
                    IDocument doc = (IDocument)LiveEditConnector.this.documentMappings.get(fullPath);
                    if (doc != null) {
                        doc.addDocumentListener(LiveEditConnector.this.documentListener);
                    }
                    if ((repository = LiveEditConnector.this.repository).isConnected(project)) {
                        ConnectedProject connectedProject = repository.getProject(project);
                        String hash = connectedProject.getHash(resourcePath);
                        long timestamp = connectedProject.getTimestamp(resourcePath);
                        LiveEditConnector.this.liveEditCoordinator.sendLiveEditStartedMessage(LiveEditConnector.LIVE_EDIT_CONNECTOR_ID, repository.getUsername(), project.getName(), resourcePath, hash, timestamp);
                    }
                }
            }

            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
                IPath path = buffer.getLocation();
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot root = workspace.getRoot();
                IResource resource = root.findMember(path);
                if (resource != null) {
                    IProject project = resource.getProject();
                    String resourcePath = resource.getProjectRelativePath().toString();
                    String fullPath = String.valueOf(project.getName()) + "/" + resourcePath;
                    IDocument doc = (IDocument)LiveEditConnector.this.documentMappings.get(fullPath);
                    if (doc != null) {
                        doc.removeDocumentListener(LiveEditConnector.this.documentListener);
                    }
                }
            }
        };
        FileBuffers.getTextFileBufferManager().addFileBufferListener(this.fileBufferListener);
        this.repositoryListener = new IRepositoryListener(){

            public void projectConnected(IProject project) {
                LiveEditConnector.this.connectOpenEditors(project);
            }

            public void projectDisconnected(IProject project) {
                LiveEditConnector.this.disconnectOpenEditors(project);
            }

            public void resourceChanged(final IResource resource) {
                if (resource == null) {
                    return;
                }
                UIJob job = new UIJob("Sync Save"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IFileBuffer fileBuffer = FileBuffers.getTextFileBufferManager().getFileBuffer(resource.getLocation(), LocationKind.NORMALIZE);
                        if (fileBuffer != null) {
                            try {
                                fileBuffer.revert((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        };
        this.repository.addRepositoryListener(this.repositoryListener);
        this.liveEditConnector = new ILiveEditConnector(){

            public String getConnectorID() {
                return LiveEditConnector.LIVE_EDIT_CONNECTOR_ID;
            }

            public void liveEditingEvent(String username, String resourcePath, int offset, int removeCount, String newText) {
                LiveEditConnector.this.handleModelChanged(username, resourcePath, offset, removeCount, newText);
            }

            public void liveEditingStarted(String requestSenderID, int callbackID, String username, String resourcePath, String hash, long timestamp) {
                LiveEditConnector.this.remoteEditorStarted(requestSenderID, callbackID, username, resourcePath, hash, timestamp);
            }

            public void liveEditingStartedResponse(String requestSenderID, int callbackID, String username, String projectName, String resourcePath, String savePointHash, long savePointTimestamp, String content) {
                LiveEditConnector.this.handleRemoteLiveContent(requestSenderID, callbackID, username, projectName, resourcePath, savePointHash, savePointTimestamp, content);
            }

            public void liveEditors(String requestSenderID, int callbackID, String username, String projectRegEx, String resourceRegEx) {
                LiveEditConnector.this.handleLiveEditors(requestSenderID, callbackID, username, projectRegEx, resourceRegEx);
            }
        };
        this.liveEditCoordinator.addLiveEditConnector(this.liveEditConnector);
        this.workspaceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                LiveEditConnector.this.reactToResourceChanged(event);
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.workspaceListener);
        this.partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part instanceof AbstractTextEditor) {
                    LiveEditConnector.this.connectEditor((AbstractTextEditor)part);
                }
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part instanceof AbstractTextEditor) {
                    LiveEditConnector.this.disconnectEditor((AbstractTextEditor)part);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        WorkbenchJob workbenchJob = new WorkbenchJob("add part listener"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                window.getActivePage().addPartListener(LiveEditConnector.this.partListener);
                return Status.OK_STATUS;
            }
        };
        workbenchJob.setSystem(true);
        workbenchJob.schedule();
        ConnectedProject[] connectedProjectArray = repository.getConnectedProjects();
        int n = connectedProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectedProject connectedProject = connectedProjectArray[n2];
            this.connectOpenEditors(connectedProject.getProject());
            ++n2;
        }
    }

    protected void remoteEditorStarted(String requestSenderID, int callbackID, String username, String resourcePath, String hash, long timestamp) {
        if (this.repository.getUsername().equals(username) && this.documentMappings.containsKey(resourcePath)) {
            IDocument document = (IDocument)this.documentMappings.get(resourcePath);
            String content = document.get();
            String projectName = resourcePath.substring(0, resourcePath.indexOf(47));
            String relativeResourcePath = resourcePath.substring(projectName.length() + 1);
            String liveUnitHash = DigestUtils.shaHex((String)content);
            if (!liveUnitHash.equals(hash)) {
                this.liveEditCoordinator.sendLiveEditStartedResponse(LIVE_EDIT_CONNECTOR_ID, requestSenderID, callbackID, username, projectName, relativeResourcePath, hash, timestamp, content);
            }
        }
    }

    private void handleLiveEditors(String requestSenderID, int callbackID, String username, String projectRegEx, String resourceRegEx) {
        HashMap<String, ArrayList<LiveEditCoordinator.ResourceData>> editUnits = new HashMap<String, ArrayList<LiveEditCoordinator.ResourceData>>();
        for (Map.Entry entry : this.documentMappings.entrySet()) {
            String resourcePath = (String)entry.getKey();
            String projectName = resourcePath.substring(0, resourcePath.indexOf(47));
            String relativeResourcePath = resourcePath.substring(projectName.length() + 1);
            if (projectRegEx != null && !Pattern.matches(projectRegEx, projectName) || resourceRegEx != null && !Pattern.matches(resourceRegEx, relativeResourcePath)) continue;
            ConnectedProject connectedProject = this.repository.getProject(projectName);
            String hash = connectedProject.getHash(relativeResourcePath);
            long timestamp = connectedProject.getTimestamp(relativeResourcePath);
            ArrayList<LiveEditCoordinator.ResourceData> resources = (ArrayList<LiveEditCoordinator.ResourceData>)editUnits.get(projectName);
            if (resources == null) {
                resources = new ArrayList<LiveEditCoordinator.ResourceData>();
                editUnits.put(projectName, resources);
            }
            resources.add(new LiveEditCoordinator.ResourceData(relativeResourcePath, hash, timestamp));
        }
        this.liveEditCoordinator.sendLiveResourcesResponse(requestSenderID, callbackID, this.repository.getUsername(), editUnits);
    }

    protected void handleRemoteLiveContent(String requestSenderID, int callbackID, String username, String projectName, String resource, String savePointHash, long savePointTimestamp, String content) {
        PendingLiveEditStartedResponse newResponse = new PendingLiveEditStartedResponse(username, projectName, resource, savePointHash, savePointTimestamp, content);
        this.handleRemoteLiveContent(newResponse);
    }

    protected void handleRemoteLiveContent(final PendingLiveEditStartedResponse pendingResponse) {
        final String resourcePath = String.valueOf(pendingResponse.getProjectName()) + "/" + pendingResponse.getResource();
        if (this.repository.getUsername().equals(pendingResponse.getUsername()) && this.documentMappings.containsKey(resourcePath)) {
            final IDocument document = (IDocument)this.documentMappings.get(resourcePath);
            try {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConnectedProject connectedProject = LiveEditConnector.this.repository.getProject(pendingResponse.getProjectName());
                            String hash = connectedProject.getHash(pendingResponse.getResource());
                            long timestamp = connectedProject.getTimestamp(pendingResponse.getResource());
                            if (hash != null && hash.equals(pendingResponse.getSavePointHash()) && timestamp == pendingResponse.getSavePointTimestamp()) {
                                String openedContent = document.get();
                                if (!openedContent.equals(pendingResponse.getContent())) {
                                    document.removeDocumentListener(LiveEditConnector.this.documentListener);
                                    document.set(pendingResponse.getContent());
                                    document.addDocumentListener(LiveEditConnector.this.documentListener);
                                }
                            } else if (pendingResponse.getSavePointTimestamp() > timestamp) {
                                PendingLiveEditStartedResponse existingPendingRespose = LiveEditConnector.this.pendingLiveEditStartedResponses.putIfAbsent(resourcePath, pendingResponse);
                                if (pendingResponse.getSavePointTimestamp() > existingPendingRespose.getSavePointTimestamp()) {
                                    LiveEditConnector.this.pendingLiveEditStartedResponses.put(resourcePath, pendingResponse);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void handleModelChanged(String username, String resourcePath, final int offset, final int removedCharCount, final String newText) {
        if (this.repository.getUsername().equals(username) && resourcePath != null && this.documentMappings.containsKey(resourcePath)) {
            final IDocument document = (IDocument)this.documentMappings.get(resourcePath);
            try {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            document.removeDocumentListener(LiveEditConnector.this.documentListener);
                            document.replace(offset, removedCharCount, newText);
                            document.addDocumentListener(LiveEditConnector.this.documentListener);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void sendModelChangedMessage(DocumentEvent event) {
        String resourcePath = (String)this.resourceMappings.get(event.getDocument());
        if (resourcePath != null) {
            String projectName = resourcePath.substring(0, resourcePath.indexOf(47));
            String relativeResourcePath = resourcePath.substring(projectName.length() + 1);
            this.liveEditCoordinator.sendModelChangedMessage(LIVE_EDIT_CONNECTOR_ID, this.repository.getUsername(), projectName, relativeResourcePath, event.getOffset(), event.getLength(), event.getText());
        }
    }

    protected void connectEditor(AbstractTextEditor texteditor) {
        IDocument document = texteditor.getDocumentProvider().getDocument((Object)texteditor.getEditorInput());
        IResource editorResource = (IResource)texteditor.getEditorInput().getAdapter(IResource.class);
        if (document != null && editorResource != null) {
            IProject project = editorResource.getProject();
            String projectName = project.getName();
            String resource = editorResource.getProjectRelativePath().toString();
            String resourcePath = String.valueOf(projectName) + "/" + resource;
            if (this.repository.isConnected(project)) {
                this.documentMappings.put(resourcePath, document);
                this.resourceMappings.put(document, resourcePath);
                document.addDocumentListener(this.documentListener);
                ConnectedProject connectedProject = this.repository.getProject(project);
                String hash = connectedProject.getHash(resource);
                long timestamp = connectedProject.getTimestamp(resource);
                this.liveEditCoordinator.sendLiveEditStartedMessage(LIVE_EDIT_CONNECTOR_ID, this.repository.getUsername(), projectName, resource, hash, timestamp);
            }
        }
    }

    protected void disconnectEditor(AbstractTextEditor texteditor) {
        IDocument document = texteditor.getDocumentProvider().getDocument((Object)texteditor.getEditorInput());
        String resourcePath = (String)this.resourceMappings.get(document);
        if (resourcePath != null) {
            document.removeDocumentListener(this.documentListener);
            this.documentMappings.remove(resourcePath);
            this.resourceMappings.remove(document);
        }
    }

    protected void connectOpenEditors(IProject project) {
        new WorkbenchJob("Connecting opened editors to Flux..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IEditorReference[] editorReferences;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IEditorReference[] iEditorReferenceArray = editorReferences = window.getActivePage().getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    IEditorPart editorPart = editorReference.getEditor(false);
                    if (editorPart instanceof AbstractTextEditor) {
                        LiveEditConnector.this.connectEditor((AbstractTextEditor)editorPart);
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void disconnectOpenEditors(IProject project) {
        new WorkbenchJob("Disconnecting opened editors from Flux..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IEditorReference[] editorReferences;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IEditorReference[] iEditorReferenceArray = editorReferences = window.getActivePage().getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    IEditorPart editorPart = editorReference.getEditor(false);
                    if (editorPart instanceof AbstractTextEditor) {
                        LiveEditConnector.this.disconnectEditor((AbstractTextEditor)editorPart);
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void reactToResourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        LiveEditConnector.this.reactToResourceChanged(delta);
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void reactToResourceChanged(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        if (project != null && this.repository.isConnected(project)) {
            this.reactToResourceChange(delta);
        }
    }

    private void reactToResourceChange(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource != null && resource.isDerived(512)) {
            return;
        }
        switch (delta.getKind()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.reactOnResourceChange(resource);
            }
        }
    }

    private void reactOnResourceChange(IResource resource) {
        if (resource != null && resource instanceof IFile) {
            String key;
            PendingLiveEditStartedResponse pendingResponse;
            ConnectedProject connectedProject = this.repository.getProject(resource.getProject());
            String resourcePath = resource.getProjectRelativePath().toString();
            if (connectedProject != null && connectedProject.containsResource(resourcePath) && (pendingResponse = this.pendingLiveEditStartedResponses.get(key = String.valueOf(connectedProject.getName()) + "/" + resourcePath)) != null) {
                this.handleRemoteLiveContent(pendingResponse);
            }
        }
    }

    public void dispose() {
        this.liveEditCoordinator.removeLiveEditConnector(this.liveEditConnector);
        this.repository.removeRepositoryListener(this.repositoryListener);
        FileBuffers.getTextFileBufferManager().removeFileBufferListener(this.fileBufferListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceListener);
        WorkbenchJob jw = new WorkbenchJob("Removing listener"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    window.getActivePage().removePartListener(LiveEditConnector.this.partListener);
                }
                return Status.OK_STATUS;
            }
        };
        jw.setSystem(true);
        jw.schedule();
        for (IDocument document : this.documentMappings.values()) {
            if (document == null) continue;
            document.removeDocumentListener(this.documentListener);
        }
        this.resourceMappings.clear();
        this.documentMappings.clear();
    }
}

