/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.ui.integration.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.core.Activator;
import org.eclipse.flux.core.DownloadProject;
import org.eclipse.flux.core.Repository;
import org.eclipse.flux.ui.integration.FluxUiPlugin;
import org.eclipse.flux.ui.integration.handlers.SyncDownloadSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;

public class SyncDownloadHandler
extends AbstractHandler {
    public static final String ID = "org.springsource.ide.eclipse.ui.cloudsync.connect";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Repository repository = Activator.getDefault().getRepository();
        MessageConnector messagingConnector = Activator.getDefault().getMessageConnector();
        if (repository == null || messagingConnector == null) {
            return null;
        }
        Shell shell = FluxUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        SyncDownloadSelectionDialog selectionDialog = new SyncDownloadSelectionDialog(shell, (ILabelProvider)new LabelProvider(), messagingConnector, repository.getUsername());
        int result = selectionDialog.open();
        if (result == 0) {
            Object[] selectedProjects;
            Object[] objectArray = selectedProjects = selectionDialog.getResult();
            int n = selectedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedProject = objectArray[n2];
                if (selectedProject instanceof String) {
                    DownloadProject downloadProject = new DownloadProject(messagingConnector, (String)selectedProject, repository.getUsername());
                    downloadProject.run(new DownloadProject.CompletionCallback(){

                        public void downloadFailed() {
                        }

                        public void downloadComplete(IProject project) {
                            repository.addProject(project);
                        }
                    });
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isEnabled() {
        Repository repository = Activator.getDefault().getRepository();
        MessageConnector messagingConnector = Activator.getDefault().getMessageConnector();
        return repository != null && messagingConnector != null;
    }
}

