/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.ui.integration.handlers;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.flux.client.CallbackIDAwareMessageHandler;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.json.JSONArray;
import org.json.JSONObject;

public class SyncDownloadSelectionDialog
extends ElementListSelectionDialog {
    private final MessageConnector messagingConnector;
    private final String username;
    private CallbackIDAwareMessageHandler responseHandler;
    private Set<String> projects;

    public SyncDownloadSelectionDialog(Shell parent, ILabelProvider renderer, MessageConnector messagingConnector, String username) {
        super(parent, renderer);
        this.messagingConnector = messagingConnector;
        this.username = username;
        this.setMultipleSelection(true);
        this.setAllowDuplicates(false);
        this.setTitle("Import Synced Projects...");
        this.projects = new ConcurrentSkipListSet<String>();
    }

    public int open() {
        try {
            int callbackID = ((Object)((Object)this)).hashCode();
            this.projects.clear();
            this.responseHandler = new CallbackIDAwareMessageHandler("getProjectsResponse", callbackID){

                public void handle(String messageType, JSONObject response) {
                    try {
                        boolean newProjects = false;
                        JSONArray projectsList = response.getJSONArray("projects");
                        int i = 0;
                        while (i < projectsList.length()) {
                            JSONObject project = projectsList.getJSONObject(i);
                            String projectName = project.getString("name");
                            newProjects |= SyncDownloadSelectionDialog.this.projects.add(projectName);
                            ++i;
                        }
                        if (newProjects) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    SyncDownloadSelectionDialog.this.setListElements(SyncDownloadSelectionDialog.this.projects.toArray(new String[SyncDownloadSelectionDialog.this.projects.size()]));
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            this.messagingConnector.addMessageHandler((IMessageHandler)this.responseHandler);
            JSONObject message = new JSONObject();
            message.put("callback_id", callbackID);
            message.put("username", (Object)this.username);
            this.messagingConnector.send("getProjectsRequest", message);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return super.open();
    }

    public boolean close() {
        this.messagingConnector.removeMessageHandler((IMessageHandler)this.responseHandler);
        return super.close();
    }
}

