/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.ui.integration.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.flux.core.Activator;
import org.eclipse.flux.core.Repository;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class SyncConnectHandler
extends AbstractHandler {
    public static final String ID = "org.springsource.ide.eclipse.ui.cloudsync.connect";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IProject[] selectedProjects = this.getSelectedProjects(selection);
        Repository repository = Activator.getDefault().getRepository();
        if (repository != null) {
            IProject[] iProjectArray = selectedProjects;
            int n = selectedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!repository.isConnected(project)) {
                    repository.addProject(project);
                }
                ++n2;
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        IEvaluationContext evalContext;
        Object selection;
        Repository repository = Activator.getDefault().getRepository();
        if (repository != null && evaluationContext instanceof IEvaluationContext && (selection = (evalContext = (IEvaluationContext)evaluationContext).getVariable("selection")) instanceof ISelection) {
            IProject[] selectedProjects;
            IProject[] iProjectArray = selectedProjects = this.getSelectedProjects((ISelection)selection);
            int n = selectedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!repository.isConnected(project)) {
                    this.setBaseEnabled(true);
                    return;
                }
                ++n2;
            }
        }
        this.setBaseEnabled(false);
    }

    protected IProject[] getSelectedProjects(ISelection selection) {
        ArrayList<IProject> selectedProjects = new ArrayList<IProject>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] selectedObjects = structuredSelection.toArray();
            int i = 0;
            while (i < selectedObjects.length) {
                IProject project;
                if (selectedObjects[i] instanceof IAdaptable && (project = (IProject)((IAdaptable)selectedObjects[i]).getAdapter(IProject.class)) != null) {
                    selectedProjects.add(project);
                }
                ++i;
            }
        }
        return selectedProjects.toArray(new IProject[selectedProjects.size()]);
    }
}

