/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.ui.integration.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.flux.core.Activator;
import org.eclipse.flux.ui.integration.FluxUiPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class ConnectionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final boolean editable = Activator.isConnectionSettingsViaPreferences();
    private Text url;
    private Text user;
    private Text token;

    protected Control createContents(Composite parent) {
        Composite mainComposite = new Composite(parent, parent.getStyle());
        mainComposite.setLayout((Layout)new GridLayout());
        this.createConnectionGroup(mainComposite).setLayoutData((Object)new GridData(768));
        return mainComposite;
    }

    private Control createConnectionGroup(Composite parent) {
        Group group = new Group(parent, 1);
        group.setText("Connection Settings");
        group.setToolTipText("Flux messaging server connection info");
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText("Server URL:");
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.url = new Text((Composite)group, 2048);
        this.url.setText(this.editable ? this.getPreferenceStore().getString("FLUX_URL") : Activator.getHostUrl());
        this.url.setEnabled(this.editable);
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (ConnectionPreferencePage.this.url.getText().isEmpty()) {
                    ConnectionPreferencePage.this.setErrorMessage(null);
                    ConnectionPreferencePage.this.setValid(true);
                } else {
                    try {
                        new URL(ConnectionPreferencePage.this.url.getText());
                        ConnectionPreferencePage.this.setErrorMessage(null);
                        ConnectionPreferencePage.this.setValid(true);
                    }
                    catch (MalformedURLException e) {
                        ConnectionPreferencePage.this.setErrorMessage(e.getMessage());
                        ConnectionPreferencePage.this.setValid(false);
                    }
                }
            }
        });
        gridData = new GridData(768);
        this.url.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        label.setText("GitHub ID:");
        label.setLayoutData((Object)new GridData());
        this.user = new Text((Composite)group, 2048);
        this.user.setText(this.editable ? this.getPreferenceStore().getString("FLUX_USER_ID") : Activator.getUserId());
        this.user.setEnabled(this.editable);
        this.user.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)group, 0);
        label.setText("GitHub Token:");
        label.setLayoutData((Object)new GridData());
        this.token = new Text((Composite)group, 2048);
        this.token.setText(this.editable ? this.getPreferenceStore().getString("FLUX_USER_TOKEN") : Activator.getUserToken());
        this.token.setEnabled(this.editable);
        this.token.setLayoutData((Object)new GridData(768));
        return group;
    }

    protected void performDefaults() {
        if (this.editable) {
            this.url.setText(this.getPreferenceStore().getDefaultString("FLUX_URL"));
            this.user.setText(this.getPreferenceStore().getDefaultString("FLUX_USER_ID"));
            this.token.setText(this.getPreferenceStore().getDefaultString("FLUX_USER_TOKEN"));
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (!(!this.editable || this.getPreferenceStore().getString("FLUX_URL").equals(this.url.getText()) && this.getPreferenceStore().getString("FLUX_USER_ID").equals(this.user.getText()) && this.getPreferenceStore().getString("FLUX_USER_TOKEN").equals(this.token.getText()))) {
            this.getPreferenceStore().setValue("FLUX_URL", this.url.getText());
            this.getPreferenceStore().setValue("FLUX_USER_ID", this.user.getText());
            this.getPreferenceStore().setValue("FLUX_USER_TOKEN", this.token.getText());
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"Restart workbench", (String)"Workbench needs to be restarted for new settings to take effect. Do you want to restart the Workbench now?\n\nEnsure all work is saved before clicking \"Yes\"")) {
                try {
                    InstanceScope.INSTANCE.getNode("org.eclipse.flux.core").flush();
                    return PlatformUI.getWorkbench().restart();
                }
                catch (BackingStoreException e) {
                    FluxUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.flux.ui.integration", "Cannot save preferences changes!", (Throwable)e));
                    e.printStackTrace();
                }
            }
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.setDescription("Allows setting of various Flux server connection parameters.");
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.flux.core"));
        if (!this.editable) {
            this.setMessage("Settings cannot be changed from UI. They are set via environment variable and/or command line arguments", 2);
        }
    }
}

