/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import java.io.IOException;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.jdt.services.JavaDocCommentReader;
import org.eclipse.flux.jdt.services.LiveEditUnits;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.json.JSONException;
import org.json.JSONObject;

public class JavaDocService {
    private MessageConnector messagingConnector;
    private LiveEditUnits liveEditUnits;
    private IMessageHandler javadocRequestHandler;

    public JavaDocService(MessageConnector messagingConnector, LiveEditUnits liveEditUnits) {
        this.messagingConnector = messagingConnector;
        this.liveEditUnits = liveEditUnits;
        this.javadocRequestHandler = new MessageHandler("javadocrequest"){

            public void handle(String messageType, JSONObject message) {
                JavaDocService.this.handleJavadocRequest(message);
            }
        };
        messagingConnector.addMessageHandler(this.javadocRequestHandler);
    }

    protected void handleJavadocRequest(JSONObject message) {
        try {
            String username = message.getString("username");
            String projectName = message.getString("project");
            String resourcePath = message.getString("resource");
            int callbackID = message.getInt("callback_id");
            String liveEditID = String.valueOf(projectName) + "/" + resourcePath;
            if (this.liveEditUnits.isLiveEditResource(username, liveEditID)) {
                int offset = message.getInt("offset");
                int length = message.getInt("length");
                String sender = message.getString("requestSenderID");
                JSONObject javadocResult = this.getJavadoc(username, liveEditID, offset, length);
                if (javadocResult != null) {
                    JSONObject responseMessage = new JSONObject();
                    responseMessage.put("username", (Object)username);
                    responseMessage.put("project", (Object)projectName);
                    responseMessage.put("resource", (Object)resourcePath);
                    responseMessage.put("callback_id", callbackID);
                    responseMessage.put("requestSenderID", (Object)sender);
                    responseMessage.put("javadoc", (Object)javadocResult);
                    this.messagingConnector.send("javadocresponse", responseMessage);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONObject getJavadoc(String username, String requestorResourcePath, int offset, int length) {
        try {
            IJavaElement[] elements;
            ICompilationUnit liveEditUnit = this.liveEditUnits.getLiveEditUnit(username, requestorResourcePath);
            if (liveEditUnit != null && (elements = liveEditUnit.codeSelect(offset, length)) != null && elements.length > 0) {
                JSONObject result = new JSONObject();
                IJavaElement element = elements[0];
                String javadoc = null;
                javadoc = element instanceof IMember && !((IMember)element).isBinary() ? this.getJavadocFromSourceElement((IMember)element) : element.getAttachedJavadoc(null);
                result.put("javadoc", (Object)javadoc);
                return result;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getJavadocFromSourceElement(IMember member) {
        block13: {
            try (JavaDocCommentReader reader = null;){
                IBuffer buffer = member.getOpenable().getBuffer();
                if (buffer == null) {
                    return null;
                }
                ISourceRange javadocRange = member.getJavadocRange();
                if (javadocRange == null) break block13;
                reader = new JavaDocCommentReader(buffer, javadocRange.getOffset(), javadocRange.getOffset() + javadocRange.getLength() - 1);
                StringBuffer buf = new StringBuffer();
                char[] charBuffer = new char[1024];
                try {
                    int count;
                    while ((count = reader.read(charBuffer)) != -1) {
                        buf.append(charBuffer, 0, count);
                    }
                }
                catch (IOException iOException) {
                    if (reader != null) {
                        reader.close();
                    }
                    return null;
                }
                String string = buf.toString();
                return string;
            }
        }
        return null;
    }

    public void dispose() {
        this.messagingConnector.removeMessageHandler(this.javadocRequestHandler);
    }
}

