/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.flux.client.CallbackIDAwareMessageHandler;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.core.ILiveEditConnector;
import org.eclipse.flux.core.IRepositoryListener;
import org.eclipse.flux.core.LiveEditCoordinator;
import org.eclipse.flux.core.Repository;
import org.eclipse.flux.jdt.services.LiveEditProblemRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveEditUnits {
    private static final String LIVE_EDIT_CONNECTOR_ID = "JDT-Service-Live-Edit-Connector";
    private static int GET_LIVE_RESOURCES_CALLBACK = "LiveEditUnits - getLiveResourcesCallback".hashCode();
    private ConcurrentMap<String, ICompilationUnit> liveEditUnits;
    private Repository repository;
    private MessageConnector messagingConnector;
    private LiveEditCoordinator liveEditCoordinator;
    private ILiveEditConnector liveEditConnector;
    private IRepositoryListener repositoryListener;
    private IResourceChangeListener metadataChangeListener;
    private IMessageHandler liveResourcesResponseHandler;

    public LiveEditUnits(MessageConnector messagingConnector, LiveEditCoordinator liveEditCoordinator, Repository repository) {
        this.messagingConnector = messagingConnector;
        this.liveEditCoordinator = liveEditCoordinator;
        this.repository = repository;
        this.liveEditUnits = new ConcurrentHashMap<String, ICompilationUnit>();
        this.liveEditConnector = new ILiveEditConnector(){

            public String getConnectorID() {
                return LiveEditUnits.LIVE_EDIT_CONNECTOR_ID;
            }

            public void liveEditingEvent(String username, String resourcePath, int offset, int removeCount, String newText) {
                LiveEditUnits.this.modelChanged(username, resourcePath, offset, removeCount, newText);
            }

            public void liveEditingStarted(String requestSenderID, int callbackID, String username, String resourcePath, String hash, long timestamp) {
                LiveEditUnits.this.startLiveUnit(requestSenderID, callbackID, username, resourcePath, hash, timestamp);
            }

            public void liveEditingStartedResponse(String requestSenderID, int callbackID, String username, String projectName, String resourcePath, String savePointHash, long savePointTimestamp, String content) {
                LiveEditUnits.this.updateLiveUnit(requestSenderID, callbackID, username, projectName, resourcePath, savePointHash, savePointTimestamp, content);
            }

            public void liveEditors(String requestSenderID, int callbackID, String username, String projectRegEx, String resourceRefEx) {
            }
        };
        liveEditCoordinator.addLiveEditConnector(this.liveEditConnector);
        this.repositoryListener = new IRepositoryListener(){

            public void projectConnected(IProject project) {
                LiveEditUnits.this.startupConnectedProject(project);
            }

            public void projectDisconnected(IProject project) {
            }

            public void resourceChanged(IResource resource) {
            }
        };
        this.repository.addRepositoryListener(this.repositoryListener);
        this.startup();
        this.liveResourcesResponseHandler = new CallbackIDAwareMessageHandler("getLiveResourcesResponse", GET_LIVE_RESOURCES_CALLBACK){

            public void handle(String messageType, JSONObject message) {
                LiveEditUnits.this.startupLiveUnits(message);
            }
        };
        messagingConnector.addMessageHandler(this.liveResourcesResponseHandler);
        this.metadataChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            LiveEditUnits.this.checkForLiveUnitsInvolved(delta);
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.metadataChangeListener, 16);
    }

    protected void startup() {
        try {
            JSONObject message = new JSONObject();
            message.put("username", (Object)this.repository.getUsername());
            message.put("callback_id", GET_LIVE_RESOURCES_CALLBACK);
            message.put("resourceRegEx", (Object)".*\\.java|.*\\.class");
            this.messagingConnector.send("getLiveResourcesRequest", message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void startupConnectedProject(IProject project) {
        try {
            JSONObject message = new JSONObject();
            message.put("username", (Object)this.repository.getUsername());
            message.put("projectRegEx", (Object)project.getName());
            message.put("callback_id", GET_LIVE_RESOURCES_CALLBACK);
            this.messagingConnector.send("getLiveResourcesRequest", message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void disconnect() {
    }

    public boolean isLiveEditResource(String username, String resourcePath) {
        return this.repository.getUsername().equals(username) && this.liveEditUnits.containsKey(resourcePath);
    }

    public ICompilationUnit getLiveEditUnit(String username, String resourcePath) {
        if (this.repository.getUsername().equals(username)) {
            return (ICompilationUnit)this.liveEditUnits.get(resourcePath);
        }
        return null;
    }

    protected void startupLiveUnits(JSONObject message) {
        try {
            String username = message.getString("username");
            JSONObject liveUnits = message.getJSONObject("liveEditUnits");
            String[] stringArray = JSONObject.getNames((JSONObject)liveUnits);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String projectName = stringArray[n2];
                JSONArray resources = liveUnits.getJSONArray(projectName);
                int i = 0;
                while (i < resources.length()) {
                    JSONObject liveUnit = resources.getJSONObject(i);
                    String resource = liveUnit.getString("resource");
                    long timestamp = liveUnit.getLong("savePointTimestamp");
                    String hash = liveUnit.getString("savePointHash");
                    String resourcePath = String.valueOf(projectName) + "/" + resource;
                    if (this.repository.getUsername().equals(username) && !this.liveEditUnits.containsKey(resourcePath)) {
                        this.startLiveUnit(null, 0, username, resourcePath, hash, timestamp);
                    }
                    this.liveEditCoordinator.sendLiveEditStartedMessage(LIVE_EDIT_CONNECTOR_ID, username, projectName, resource, hash, timestamp);
                    ++i;
                }
                ++n2;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    protected void startLiveUnit(String requestSenderID, int callbackID, String username, String resourcePath, String hash, long timestamp) {
        String projectName = resourcePath.substring(0, resourcePath.indexOf(47));
        String relativeResourcePath = resourcePath.substring(projectName.length() + 1);
        if (this.repository.getUsername().equals(username) && resourcePath.endsWith(".java") && this.repository.isConnected(projectName)) {
            ICompilationUnit liveUnit = (ICompilationUnit)this.liveEditUnits.get(resourcePath);
            if (liveUnit != null) {
                try {
                    String liveContent = liveUnit.getBuffer().getContents();
                    String liveUnitHash = DigestUtils.shaHex((String)liveContent);
                    if (!liveUnitHash.equals(hash)) {
                        this.liveEditCoordinator.sendLiveEditStartedResponse(LIVE_EDIT_CONNECTOR_ID, requestSenderID, callbackID, username, projectName, relativeResourcePath, hash, timestamp, liveContent);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            } else {
                IFile file;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && this.repository.isConnected(project) && (file = project.getFile(relativeResourcePath)) != null) {
                    try {
                        final LiveEditProblemRequestor liveEditProblemRequestor = new LiveEditProblemRequestor(this.messagingConnector, username, projectName, relativeResourcePath);
                        liveUnit = ((ICompilationUnit)JavaCore.create((IFile)file)).getWorkingCopy(new WorkingCopyOwner(){

                            public IProblemRequestor getProblemRequestor(ICompilationUnit workingCopy) {
                                return liveEditProblemRequestor;
                            }
                        }, (IProgressMonitor)new NullProgressMonitor());
                        this.liveEditUnits.put(resourcePath, liveUnit);
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (liveUnit != null) {
                try {
                    liveUnit.reconcile(0, true, null, null);
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void updateLiveUnit(String requestSenderID, int callbackID, String username, String projectName, String resource, String savePointHash, long savePointTimestamp, String remoteContent) {
        String resourcePath;
        ICompilationUnit liveUnit;
        if (this.repository.getUsername().equals(username) && resource.endsWith(".java") && this.repository.isConnected(projectName) && (liveUnit = (ICompilationUnit)this.liveEditUnits.get(resourcePath = String.valueOf(projectName) + "/" + resource)) != null) {
            try {
                String liveContent = liveUnit.getBuffer().getContents();
                String liveUnitHash = DigestUtils.shaHex((String)liveContent);
                String remoteContentHash = DigestUtils.shaHex((String)remoteContent);
                if (!liveUnitHash.equals(remoteContentHash)) {
                    liveUnit.getBuffer().setContents(remoteContent);
                    liveUnit.reconcile(0, true, null, null);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    protected void modelChanged(String username, String resourcePath, int offset, int removedCharacterCount, String newText) {
        if (this.repository.getUsername().equals(username) && this.liveEditUnits.containsKey(resourcePath)) {
            System.out.println("live edit compilation unit found");
            ICompilationUnit unit = (ICompilationUnit)this.liveEditUnits.get(resourcePath);
            try {
                IBuffer buffer = unit.getBuffer();
                buffer.replace(offset, removedCharacterCount, newText);
                if (removedCharacterCount > 0 || newText.length() > 0) {
                    unit.reconcile(0, true, null, null);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    protected void checkForLiveUnitsInvolved(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
        if (project != null && this.repository.isConnected(project) && markerDeltas != null && markerDeltas.length > 0) {
            IResource resource = delta.getResource();
            String resourcePath = String.valueOf(project.getName()) + "/" + resource.getProjectRelativePath().toString();
            ICompilationUnit unit = this.getLiveEditUnit(this.repository.getUsername(), resourcePath);
            if (unit != null) {
                try {
                    unit.reconcile(0, true, null, null);
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void dispose() {
        this.messagingConnector.removeMessageHandler(this.liveResourcesResponseHandler);
        this.liveEditCoordinator.removeLiveEditConnector(this.liveEditConnector);
        this.repository.removeRepositoryListener(this.repositoryListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.metadataChangeListener);
        this.liveEditUnits.clear();
    }
}

