/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import java.util.regex.Pattern;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;

public class CodeStyleConfiguration {
    private static final Pattern SEMICOLON_PATTERN = Pattern.compile(";");

    private CodeStyleConfiguration() {
    }

    public static ImportRewrite createImportRewrite(ICompilationUnit cu, boolean restoreExistingImports) throws JavaModelException {
        return CodeStyleConfiguration.configureImportRewrite(ImportRewrite.create((ICompilationUnit)cu, (boolean)restoreExistingImports));
    }

    public static ImportRewrite createImportRewrite(CompilationUnit astRoot, boolean restoreExistingImports) {
        return CodeStyleConfiguration.configureImportRewrite(ImportRewrite.create((CompilationUnit)astRoot, (boolean)restoreExistingImports));
    }

    private static ImportRewrite configureImportRewrite(ImportRewrite rewrite) {
        rewrite.getCompilationUnit().getJavaProject();
        String order = "";
        if (order.endsWith(";")) {
            order = order.substring(0, order.length() - 1);
        }
        String[] split = SEMICOLON_PATTERN.split(order, -1);
        rewrite.setImportOrder(split);
        String thres = "10";
        try {
            int num = Integer.parseInt(thres);
            if (num == 0) {
                num = 1;
            }
            rewrite.setOnDemandImportThreshold(num);
        }
        catch (NumberFormatException numberFormatException) {}
        String thresStatic = "10";
        try {
            int num = Integer.parseInt(thresStatic);
            if (num == 0) {
                num = 1;
            }
            rewrite.setStaticOnDemandImportThreshold(num);
        }
        catch (NumberFormatException numberFormatException) {}
        return rewrite;
    }
}

