/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.filesystem.internal.Activator;
import eu.geclipse.core.filesystem.internal.filesystem.ConnectionElement;
import eu.geclipse.core.filesystem.internal.filesystem.ConnectionRoot;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.impl.AbstractGridElementCreator;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemCreator
extends AbstractGridElementCreator {
    public boolean canCreate(Class<? extends IGridElement> clazz) {
        return false;
    }

    public IGridElement create(IGridContainer iGridContainer) throws GridModelException {
        ConnectionElement connectionElement = null;
        IResource iResource = (IResource)this.getObject();
        connectionElement = this.isFileSystemLink(iResource) ? this.createConnectionRoot((IFolder)iResource) : this.createConnectionElement(iResource);
        return connectionElement;
    }

    private ConnectionElement createConnectionElement(IResource iResource) {
        ConnectionElement connectionElement = new ConnectionElement(iResource);
        return connectionElement;
    }

    private ConnectionRoot createConnectionRoot(IFolder iFolder) {
        ConnectionRoot connectionRoot = new ConnectionRoot(iFolder);
        try {
            IFileInfo iFileInfo = connectionRoot.getConnectionFileInfo();
            if (iFileInfo instanceof FileInfo) {
                ((FileInfo)iFileInfo).setExists(true);
            }
        }
        catch (CoreException coreException) {
            Activator.logException(coreException);
        }
        return connectionRoot;
    }

    protected boolean internalCanCreate(Object object) {
        boolean bl = false;
        if (object instanceof IResource) {
            bl = this.isFileSystemElement((IResource)object);
        }
        return bl;
    }

    private boolean isFileSystemElement(IResource iResource) {
        boolean bl = this.isFileSystemLink(iResource);
        if (!bl && iResource != null) {
            bl = this.isFileSystemElement((IResource)iResource.getParent());
        }
        return bl;
    }

    private boolean isFileSystemLink(IResource iResource) {
        URI uRI;
        IFolder iFolder;
        boolean bl = false;
        if (iResource != null && iResource instanceof IFolder && (iFolder = (IFolder)iResource).isLinked() && (uRI = iFolder.getRawLocationURI()) != null) {
            String string = uRI.getScheme();
            if (GEclipseURI.getScheme().equals(string)) {
                bl = true;
            }
        }
        return bl;
    }
}

