/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem;

import eu.geclipse.core.filesystem.internal.Activator;
import eu.geclipse.core.filesystem.internal.filesystem.FileSystemManager;
import eu.geclipse.core.filesystem.internal.filesystem.GEclipseFileStore;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class GEclipseFileSystem
extends FileSystem
implements IFileSystem {
    private IFileSystem slave;

    public int attributes() {
        return this.slave != null ? this.slave.attributes() : super.attributes();
    }

    public boolean canDelete() {
        return this.slave != null ? this.slave.canDelete() : super.canDelete();
    }

    public boolean canWrite() {
        return this.slave != null ? this.slave.canWrite() : super.canWrite();
    }

    public IFileTree fetchFileTree(IFileStore iFileStore, IProgressMonitor iProgressMonitor) {
        IFileTree iFileTree = null;
        if (this.slave != null && iFileStore instanceof GEclipseFileStore) {
            IFileStore iFileStore2 = ((GEclipseFileStore)iFileStore).getSlave();
            try {
                iFileTree = this.slave.fetchFileTree(iFileStore2, iProgressMonitor);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
        }
        if (iFileTree == null) {
            iFileTree = super.fetchFileTree(iFileStore, iProgressMonitor);
        }
        return iFileTree;
    }

    public IFileStore getStore(URI uRI) {
        GEclipseFileStore gEclipseFileStore = null;
        FileSystemManager fileSystemManager = FileSystemManager.getInstance();
        gEclipseFileStore = fileSystemManager.getStore(this, uRI);
        this.slave = gEclipseFileStore.getSlave().getFileSystem();
        return gEclipseFileStore;
    }

    public boolean isCaseSensitive() {
        return this.slave != null ? this.slave.isCaseSensitive() : super.isCaseSensitive();
    }
}

