/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem;

import eu.geclipse.core.filesystem.Messages;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;

public class GEclipseURI {
    private static final String SCHEME = "gecl";
    private static final String QUERY_TOKEN_SEPARATOR = "&";
    private static final String QUERY_TOKEN_ASSIGN = "=";
    private static final String QUERY_SLAVE_SCHEME_TOKEN = "geclslave";
    private static final String QUERY_UID_TOKEN = "gecluid";
    private URI masterURI;

    public GEclipseURI(URI uRI) {
        URI uRI2 = GEclipseURI.getSlaveURI(uRI);
        try {
            IFileSystem iFileSystem = EFS.getFileSystem((String)uRI2.getScheme());
            IFileStore iFileStore = iFileSystem.getStore(uRI2);
            uRI2 = iFileStore.toURI();
        }
        catch (CoreException coreException) {}
        this.masterURI = GEclipseURI.getMasterURI(uRI2);
    }

    public static String getScheme() {
        return SCHEME;
    }

    public String getSlaveScheme() {
        return this.toSlaveURI().getScheme();
    }

    public URI toMasterURI() {
        return this.masterURI;
    }

    public URI toSlaveURI() {
        return GEclipseURI.getSlaveURI(this.masterURI);
    }

    public String toString() {
        return this.toMasterURI().toString();
    }

    private static URI getMasterURI(URI uRI) {
        URI uRI2 = uRI;
        if (!GEclipseURI.isMasterURI(uRI)) {
            String string = SCHEME;
            String string2 = uRI.getUserInfo();
            String string3 = uRI.getHost();
            int n = uRI.getPort();
            String string4 = uRI.getPath();
            String string5 = uRI.getQuery();
            String string6 = uRI.getFragment();
            string5 = !GEclipseURI.isEmptyString(string5) ? String.valueOf(string5) + QUERY_TOKEN_SEPARATOR : new String();
            string5 = String.valueOf(string5) + "geclslave=" + uRI.getScheme();
            String string7 = new String();
            if (string3 != null && string3.length() > 0) {
                string7 = String.valueOf(string7) + string3;
            }
            if (n != -1) {
                string7 = String.valueOf(string7) + String.valueOf(n);
            }
            if (string7.length() > 0) {
                string5 = String.valueOf(string5) + "&gecluid=" + string7;
            }
            try {
                uRI2 = new URI(string, string2, string3, n, string4, string5, string6);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(Messages.getString("GEclipseURI.master_creation_failed"), uRISyntaxException);
            }
        }
        return uRI2;
    }

    private static URI getSlaveURI(URI uRI) {
        URI uRI2 = uRI;
        if (GEclipseURI.isMasterURI(uRI)) {
            String string = null;
            String string2 = uRI.getUserInfo();
            String string3 = uRI.getHost();
            int n = uRI.getPort();
            String string4 = uRI.getPath();
            String string5 = uRI.getQuery();
            String string6 = uRI.getFragment();
            String[] stringArray = string5.split(QUERY_TOKEN_SEPARATOR);
            string5 = new String();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string7 = stringArray2[n3];
                String[] stringArray3 = string7.split(QUERY_TOKEN_ASSIGN);
                boolean bl = true;
                if (stringArray3.length == 2) {
                    if (stringArray3[0].equals(QUERY_SLAVE_SCHEME_TOKEN)) {
                        string = stringArray3[1];
                        bl = false;
                    } else if (stringArray3[0].equals(QUERY_UID_TOKEN)) {
                        bl = false;
                    }
                }
                if (bl) {
                    if (string5.length() > 0) {
                        string5 = String.valueOf(string5) + QUERY_TOKEN_SEPARATOR;
                    }
                    string5 = String.valueOf(string5) + string7;
                }
                ++n3;
            }
            if (GEclipseURI.isEmptyString(string5)) {
                string5 = null;
            }
            try {
                uRI2 = new URI(string, string2, string3, n, string4, string5, string6);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(Messages.getString("GEclipseURI.slave_creation_failed"), uRISyntaxException);
            }
        }
        return uRI2;
    }

    private static boolean isEmptyString(String string) {
        return string == null || string.length() == 0;
    }

    private static boolean isMasterURI(URI uRI) {
        return SCHEME.equals(uRI.getScheme());
    }
}

