/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem.internal.filesystem;

import eu.geclipse.core.filesystem.GEclipseFileSystem;
import eu.geclipse.core.filesystem.internal.Activator;
import eu.geclipse.core.filesystem.internal.filesystem.GEclipseFileStore;
import eu.geclipse.core.filesystem.internal.filesystem.Messages;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ConnectionElement
extends AbstractGridContainer
implements IGridConnectionElement {
    private IResource resource;
    private Throwable fetchError;

    public ConnectionElement(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        this.resource = iResource;
    }

    public boolean canContain(IGridElement iGridElement) {
        return this.isFolder() && iGridElement instanceof IGridConnectionElement;
    }

    public IFileInfo getConnectionFileInfo() throws CoreException {
        return this.getConnectionFileStore().fetchInfo();
    }

    public IFileStore getConnectionFileStore() throws CoreException {
        IFileStore iFileStore = null;
        IResource iResource = this.getResource();
        if (iResource != null) {
            URI uRI = iResource.getLocationURI();
            GEclipseFileSystem gEclipseFileSystem = new GEclipseFileSystem();
            iFileStore = gEclipseFileSystem.getStore(uRI);
        }
        return iFileStore;
    }

    public String getError() {
        String string = null;
        if (this.fetchError != null) {
            string = this.fetchError.getLocalizedMessage();
        }
        return string;
    }

    public URI getURI() {
        URI uRI = null;
        try {
            GEclipseFileStore gEclipseFileStore = (GEclipseFileStore)this.getConnectionFileStore();
            uRI = gEclipseFileStore.getSlave().toURI();
        }
        catch (CoreException coreException) {
            Activator.logException(coreException);
        }
        return uRI;
    }

    public boolean hasChildren() {
        return this.isFolder() ? super.hasChildren() : false;
    }

    public boolean isFolder() {
        return this.getResource().getType() == 2;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isLazy() {
        return true;
    }

    public boolean isLocal() {
        boolean bl = false;
        try {
            GEclipseFileStore gEclipseFileStore = (GEclipseFileStore)this.getConnectionFileStore();
            bl = gEclipseFileStore.isLocal();
        }
        catch (CoreException coreException) {
            Activator.logException(coreException);
        }
        return bl;
    }

    public boolean isValid() {
        return this.getError() == null;
    }

    protected synchronized boolean fetchChildren(IProgressMonitor iProgressMonitor) {
        block5: {
            IProgressMonitor iProgressMonitor2 = iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor;
            this.fetchError = null;
            iProgressMonitor2.beginTask(String.format(Messages.getString("ConnectionElement.fetching_children_progress"), this.getName()), 100);
            try {
                try {
                    IResource iResource = this.getResource();
                    GEclipseFileStore gEclipseFileStore = (GEclipseFileStore)this.getConnectionFileStore();
                    gEclipseFileStore.reset();
                    iResource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor2, 10));
                    gEclipseFileStore.activate();
                    iResource.refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor2, 90));
                }
                catch (CoreException coreException) {
                    this.fetchError = coreException;
                    iProgressMonitor2.done();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                iProgressMonitor2.done();
                throw throwable;
            }
            iProgressMonitor2.done();
        }
        return this.fetchError == null;
    }

    public IFileStore getFileStore() {
        URI uRI = this.getResource().getLocationURI();
        IFileSystem iFileSystem = EFS.getLocalFileSystem();
        IFileStore iFileStore = iFileSystem.getStore(uRI);
        return iFileStore;
    }

    public String getName() {
        return this.getResource().getName();
    }

    public IGridContainer getParent() {
        IGridContainer iGridContainer = null;
        IPath iPath = this.getPath().removeLastSegments(1);
        IGridElement iGridElement = GridModel.getRoot().findElement(iPath);
        if (iGridElement instanceof IGridContainer) {
            iGridContainer = (IGridContainer)iGridElement;
        }
        return iGridContainer;
    }

    public IPath getPath() {
        return this.getResource().getFullPath();
    }

    public IResource getResource() {
        return this.resource;
    }
}

