/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem.internal.filesystem;

import eu.geclipse.core.filesystem.GEclipseFileSystem;
import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.filesystem.internal.Activator;
import eu.geclipse.core.filesystem.internal.filesystem.FileStoreRegistry;
import eu.geclipse.core.filesystem.internal.filesystem.GEclipseFileStore;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;

public class FileSystemManager {
    private static FileSystemManager instance;

    private FileSystemManager() {
    }

    public static FileSystemManager getInstance() {
        if (instance == null) {
            instance = new FileSystemManager();
        }
        return instance;
    }

    public GEclipseFileStore getStore(GEclipseFileSystem gEclipseFileSystem, URI uRI) {
        GEclipseURI gEclipseURI = new GEclipseURI(uRI);
        FileStoreRegistry fileStoreRegistry = FileStoreRegistry.getInstance();
        GEclipseFileStore gEclipseFileStore = fileStoreRegistry.getStore(gEclipseURI);
        if (gEclipseFileStore == null) {
            try {
                IFileStore iFileStore = FileSystemManager.getSlaveStore(gEclipseURI);
                gEclipseFileStore = new GEclipseFileStore(gEclipseFileSystem, iFileStore);
                fileStoreRegistry.putStore(gEclipseFileStore);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
        }
        return gEclipseFileStore;
    }

    private static IFileStore getSlaveStore(GEclipseURI gEclipseURI) throws CoreException {
        IFileSystem iFileSystem = FileSystemManager.getSlaveSystem(gEclipseURI);
        return iFileSystem.getStore(gEclipseURI.toSlaveURI());
    }

    private static IFileSystem getSlaveSystem(GEclipseURI gEclipseURI) throws CoreException {
        return EFS.getFileSystem((String)gEclipseURI.getSlaveScheme());
    }
}

