/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem.internal.filesystem;

import eu.geclipse.core.filesystem.GEclipseFileSystem;
import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.filesystem.internal.Activator;
import eu.geclipse.core.filesystem.internal.filesystem.FileStoreRegistry;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class GEclipseFileStore
extends FileStore
implements IFileStore {
    private GEclipseFileSystem fileSystem;
    private GEclipseFileStore parent;
    private IFileStore slave;
    private boolean isActive;
    private String[] childNames;

    protected GEclipseFileStore(GEclipseFileSystem gEclipseFileSystem, IFileStore iFileStore) {
        Assert.isNotNull((Object)((Object)gEclipseFileSystem));
        Assert.isNotNull((Object)iFileStore);
        this.fileSystem = gEclipseFileSystem;
        this.parent = null;
        this.slave = iFileStore;
        this.setActive(false);
    }

    private GEclipseFileStore(GEclipseFileStore gEclipseFileStore, IFileStore iFileStore) {
        Assert.isNotNull((Object)((Object)gEclipseFileStore));
        Assert.isNotNull((Object)iFileStore);
        this.fileSystem = (GEclipseFileSystem)gEclipseFileStore.getFileSystem();
        this.parent = gEclipseFileStore;
        this.slave = iFileStore;
        this.setActive(false);
    }

    public void activate() {
        this.setActive(true);
    }

    public String[] childNames(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        String[] stringArray = this.childNames;
        if (this.isActive()) {
            this.setActive(false);
            try {
                stringArray = this.getSlave().childNames(n, iProgressMonitor);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
                throw coreException;
            }
            this.childNames = stringArray;
        }
        if (stringArray == null) {
            stringArray = FileStore.EMPTY_STRING_ARRAY;
        }
        return stringArray;
    }

    public void delete(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.getSlave().delete(n, iProgressMonitor);
    }

    public IFileInfo fetchInfo(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        IFileInfo iFileInfo = this.getSlave().fetchInfo(n, iProgressMonitor);
        return iFileInfo;
    }

    public IFileStore getChild(String string) {
        FileStoreRegistry fileStoreRegistry;
        GEclipseFileStore gEclipseFileStore = null;
        IFileStore iFileStore = this.getSlave().getChild(string);
        if (iFileStore != null && (gEclipseFileStore = (fileStoreRegistry = FileStoreRegistry.getInstance()).getStore(iFileStore)) == null) {
            gEclipseFileStore = new GEclipseFileStore(this, iFileStore);
            fileStoreRegistry.putStore(gEclipseFileStore);
        }
        return gEclipseFileStore;
    }

    public IFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getName() {
        return this.getSlave().getName();
    }

    public IFileStore getParent() {
        return this.parent;
    }

    public IFileStore getSlave() {
        return this.slave;
    }

    public boolean isLocal() {
        String string = this.toGEclipseURI().getSlaveScheme();
        IFileSystem iFileSystem = EFS.getLocalFileSystem();
        String string2 = iFileSystem.getScheme();
        return string.equals(string2);
    }

    public IFileStore mkdir(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        GEclipseFileStore gEclipseFileStore = this;
        if (!this.fetchInfo().exists()) {
            IFileStore iFileStore = this.getSlave().mkdir(n, iProgressMonitor);
            FileStoreRegistry fileStoreRegistry = FileStoreRegistry.getInstance();
            gEclipseFileStore = fileStoreRegistry.getStore(iFileStore);
            if (gEclipseFileStore == null) {
                gEclipseFileStore = new GEclipseFileStore(this, iFileStore);
                fileStoreRegistry.putStore(gEclipseFileStore);
            }
        }
        return gEclipseFileStore;
    }

    public InputStream openInputStream(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.getSlave().openInputStream(n, iProgressMonitor);
    }

    public OutputStream openOutputStream(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.getSlave().openOutputStream(n, iProgressMonitor);
    }

    public void putInfo(IFileInfo iFileInfo, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.getSlave().putInfo(iFileInfo, n, iProgressMonitor);
    }

    public void reset() {
        this.childNames = null;
    }

    public GEclipseURI toGEclipseURI() {
        return new GEclipseURI(this.getSlave().toURI());
    }

    public URI toURI() {
        return this.toGEclipseURI().toMasterURI();
    }

    private boolean isActive() {
        return this.isActive;
    }

    private void setActive(boolean bl) {
        this.isActive = bl;
    }
}

