/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core;

import eu.geclipse.core.GridException;
import eu.geclipse.core.IProblem;
import eu.geclipse.core.ISolution;
import eu.geclipse.core.SolutionRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProblem
implements IProblem {
    private Throwable exception;
    private int id;
    private List<ISolution> solutions = new ArrayList<ISolution>();
    private List<Integer> solutionIDs = new ArrayList<Integer>();
    private String text;
    private List<String> reasons;

    protected AbstractProblem(int n, String string) {
        this(n, string, null);
    }

    protected AbstractProblem(int n, String string, Throwable throwable) {
        this.id = n;
        this.text = string;
        this.exception = throwable;
    }

    @Override
    public void addReason(String string) {
        if (this.reasons == null) {
            this.reasons = new ArrayList<String>();
        }
        this.reasons.add(string);
    }

    @Override
    public void addSolution(int n) {
        Integer n2 = new Integer(n);
        if (!this.solutionIDs.contains(n2)) {
            this.solutionIDs.add(n2);
        }
    }

    @Override
    public void addSolution(ISolution iSolution) {
        ISolution iSolution2 = this.findSolution(iSolution.getID());
        if (iSolution2 != null) {
            this.solutions.remove(iSolution2);
            this.solutionIDs.remove(iSolution2.getID());
        }
        this.solutions.add(iSolution);
        this.solutionIDs.add(new Integer(iSolution.getID()));
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public List<String> getReasons() {
        List<String> list;
        Throwable throwable;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.reasons != null) {
            arrayList.addAll(this.reasons);
        }
        if ((throwable = this.getException()) != null && throwable instanceof GridException && (list = ((GridException)((Object)throwable)).getProblem().getReasons()) != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    public List<ISolution> getSolutions(SolutionRegistry solutionRegistry) {
        ArrayList<ISolution> arrayList = new ArrayList<ISolution>();
        List<Integer> list = this.getSolutionIDs();
        int n = 0;
        while (n < list.size()) {
            int n2 = list.get(n);
            ISolution iSolution = this.findSolution(n2);
            if (iSolution == null) {
                iSolution = solutionRegistry.findSolution(n2);
            }
            if (iSolution != null) {
                arrayList.add(iSolution);
            }
            ++n;
        }
        return arrayList;
    }

    public List<Integer> getSolutionIDs() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Integer serializable2 : this.solutionIDs) {
            if (arrayList.contains(serializable2)) continue;
            arrayList.add(serializable2);
        }
        Throwable throwable = this.getException();
        if (throwable != null && throwable instanceof GridException) {
            IProblem iProblem = ((GridException)((Object)throwable)).getProblem();
            List<Integer> list = ((AbstractProblem)iProblem).getSolutionIDs();
            for (Integer n : list) {
                if (arrayList.contains(n)) continue;
                arrayList.add(n);
            }
        }
        return arrayList;
    }

    @Override
    public IStatus getStatus() {
        Status status = null;
        if (this.hasReasons()) {
            List<String> list = this.getReasons();
            status = new MultiStatus(this.getPluginID(), this.getID(), this.getText(), this.getException());
            for (String string : list) {
                Status status2 = new Status(4, this.getPluginID(), this.getID(), string, null);
                ((MultiStatus)status).add((IStatus)status2);
            }
        } else {
            status = new Status(4, this.getPluginID(), this.getID(), this.getText(), this.getException());
        }
        return status;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public boolean hasReasons() {
        List<String> list = this.getReasons();
        return list != null && !list.isEmpty();
    }

    protected abstract String getPluginID();

    private ISolution findSolution(int n) {
        ISolution iSolution = null;
        int n2 = 0;
        while (n2 < this.solutions.size()) {
            if (this.solutions.get(n2).getID() == n) {
                iSolution = this.solutions.get(n2);
                break;
            }
            ++n2;
        }
        return iSolution;
    }
}

