/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core;

import eu.geclipse.core.IProblem;
import eu.geclipse.core.IProblemProvider;
import eu.geclipse.core.Messages;
import eu.geclipse.core.ProblemRegistry;
import eu.geclipse.core.SolutionRegistry;

public class CoreProblems
implements IProblemProvider {
    public static final int CONNECTION_FAILED = ProblemRegistry.uniqueID();
    public static final int CONNECTION_TIMEOUT = ProblemRegistry.uniqueID();
    public static final int UNKNOWN_HOST = ProblemRegistry.uniqueID();
    public static final int MALFORMED_URL = ProblemRegistry.uniqueID();
    public static final int BIND_FAILED = ProblemRegistry.uniqueID();
    public static final int JOB_SUBMISSION_FAILED = ProblemRegistry.uniqueID();
    public static final int UNSPECIFIED_IO_PROBLEM = ProblemRegistry.uniqueID();
    public static final int FILE_ACCESS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int GET_SSH_SERVICE_FAILED = ProblemRegistry.uniqueID();
    public static final int LOGIN_FAILED = ProblemRegistry.uniqueID();
    public static final int ERROR_CREATING_CREDENTIAL = ProblemRegistry.uniqueID();
    public static final int SYSTEM_TIME_CHECK_FAILED = ProblemRegistry.uniqueID();

    public IProblem getProblem(int n, Throwable throwable) {
        IProblem iProblem = null;
        if (n == CONNECTION_TIMEOUT) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.connection_timeout"), throwable, new int[]{SolutionRegistry.SERVER_DOWN, SolutionRegistry.CHECK_TIMEOUT_SETTINGS});
        } else if (n == CONNECTION_FAILED) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.connection_failed"), throwable, new int[]{SolutionRegistry.CHECK_INTERNET_CONNECTION, SolutionRegistry.CHECK_SERVER_URL, SolutionRegistry.CHECK_PROXY_SETTINGS});
        } else if (n == UNKNOWN_HOST) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.unknown_host"), throwable, new int[]{SolutionRegistry.CHECK_INTERNET_CONNECTION, SolutionRegistry.CHECK_SERVER_URL});
        } else if (n == UNSPECIFIED_IO_PROBLEM) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.unspecified_io"), throwable, null);
        } else if (n == FILE_ACCESS_PROBLEM) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.file_access"), throwable, null);
        } else if (n == BIND_FAILED) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.bindFailed"), throwable, new int[]{SolutionRegistry.CHECK_PORT_ALREADY_IN_USE, SolutionRegistry.USE_ANOTHER_PORT});
        } else if (n == JOB_SUBMISSION_FAILED) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.job_submission_failed"), throwable, null);
        } else if (n == MALFORMED_URL) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.malformed_url"), throwable, new int[]{SolutionRegistry.CHECK_SERVER_URL});
        } else if (n == GET_SSH_SERVICE_FAILED) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.get_ssh_service_failed"), throwable, new int[]{SolutionRegistry.CHECK_INSTALLATION});
        } else if (n == LOGIN_FAILED) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.login_failed"), throwable, null);
        } else if (n == ERROR_CREATING_CREDENTIAL) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.errorCreatingCredential"), throwable, null);
        } else if (n == SYSTEM_TIME_CHECK_FAILED) {
            iProblem = this.createProblem(n, Messages.getString("CoreProblems.system_time_check_failed"), throwable, null);
        }
        return iProblem;
    }

    private IProblem createProblem(int n, String string, Throwable throwable, int[] nArray) {
        return ProblemRegistry.createProblem(n, string, throwable, nArray, "eu.geclipse.core");
    }
}

