/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core;

import eu.geclipse.core.GridException;
import eu.geclipse.core.Messages;
import eu.geclipse.core.Preferences;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.JobManager;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.core.model.IGridJobStatusListener;
import eu.geclipse.core.model.IGridJobStatusService;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class JobStatusUpdater
extends Job {
    Hashtable<IGridJobStatusListener, Integer> listeners = new Hashtable();
    IGridJobID jobID;
    IGridJob job;
    IGridJobStatus lastStatus = null;

    public JobStatusUpdater(IGridJob iGridJob) {
        super(Messages.getString("JobStatusUpdater.name"));
        this.job = iGridJob;
    }

    public JobStatusUpdater(IGridJobID iGridJobID) {
        super(Messages.getString("JobStatusUpdater.name"));
        this.jobID = iGridJobID;
    }

    public IGridJob getJob() {
        return this.job;
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        if (this.job != null && Preferences.getUpdateJobsStatus()) {
            int n = -1;
            if (this.lastStatus != null) {
                n = this.lastStatus.getType();
            }
            int n2 = 128;
            IGridJobStatus iGridJobStatus = null;
            try {
                Object object;
                Object object2;
                if (this.job != null) {
                    this.job.updateJobStatus();
                    iGridJobStatus = this.job.getJobStatus();
                } else {
                    object2 = GridModel.getElementCreators(IGridJobStatusService.class);
                    Iterator<IGridElementCreator> iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (!object.canCreate(this.jobID)) continue;
                        try {
                            IGridJobStatusService iGridJobStatusService = (IGridJobStatusService)object.create(null);
                            iGridJobStatus = iGridJobStatusService.getJobStatus(this.jobID);
                        }
                        catch (GridModelException gridModelException) {
                        }
                        catch (GridException gridException) {}
                    }
                }
                if (iGridJobStatus != null) {
                    n2 = iGridJobStatus.getType();
                    this.lastStatus = iGridJobStatus;
                }
                if (n != n2) {
                    object2 = this.listeners.keys();
                    while (object2.hasMoreElements()) {
                        object = (IGridJobStatusListener)object2.nextElement();
                        int n3 = this.listeners.get(object);
                        if ((n2 & n3) <= 0) continue;
                        object.statusChanged(this.job);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                Activator.logException(runtimeException);
            }
            if (iGridJobStatus != null && iGridJobStatus.canChange()) {
                int n4 = Preferences.getUpdateJobsPeriod();
                this.schedule(n4);
            } else {
                JobManager.getManager().removeUpdater(this);
            }
        }
        return Status.OK_STATUS;
    }

    public void statusUpdated(IGridJobStatus iGridJobStatus) {
        int n;
        int n2 = -1;
        if (this.lastStatus != null) {
            n2 = this.lastStatus.getType();
        }
        if (iGridJobStatus != null && this.lastStatus != null && n2 != (n = iGridJobStatus.getType())) {
            this.lastStatus = iGridJobStatus;
            Enumeration<IGridJobStatusListener> enumeration = this.listeners.keys();
            while (enumeration.hasMoreElements()) {
                IGridJobStatusListener iGridJobStatusListener = enumeration.nextElement();
                int n3 = this.listeners.get(iGridJobStatusListener);
                if ((n & n3) <= 0) continue;
                iGridJobStatusListener.statusChanged(this.job);
            }
        }
    }

    public void addJobStatusListener(int n, IGridJobStatusListener iGridJobStatusListener) {
        this.listeners.put(iGridJobStatusListener, new Integer(n));
    }

    public void removeJobStatusListener(IGridJobStatusListener iGridJobStatusListener) {
        this.listeners.remove(iGridJobStatusListener);
    }
}

