/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core;

import eu.geclipse.core.ISolution;
import eu.geclipse.core.Messages;
import eu.geclipse.core.Solution;
import eu.geclipse.core.internal.Activator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SolutionRegistry {
    public static final int CHECK_AUTH_DATA = SolutionRegistry.uniqueID();
    public static final int CHECK_AUTH_TOKENS = SolutionRegistry.uniqueID();
    public static final int CHECK_CA_CERTIFICATES = SolutionRegistry.uniqueID();
    public static final int CHECK_HOSTNAME_SETTINGS = SolutionRegistry.uniqueID();
    public static final int CHECK_INTERNET_CONNECTION = SolutionRegistry.uniqueID();
    public static final int CHECK_FIREWALL = SolutionRegistry.uniqueID();
    public static final int CHECK_PROXY_SETTINGS = SolutionRegistry.uniqueID();
    public static final int CHECK_TIMEOUT_SETTINGS = SolutionRegistry.uniqueID();
    public static final int CHECK_SERVER_URL = SolutionRegistry.uniqueID();
    public static final int CHECK_SYSTEM_TIME = SolutionRegistry.uniqueID();
    public static final int CHECK_VO_SETTINGS = SolutionRegistry.uniqueID();
    public static final int SERVER_DOWN = SolutionRegistry.uniqueID();
    public static final int CONTACT_SERVER_ADMINS = SolutionRegistry.uniqueID();
    public static final int DOWNLOAD_FILE_AGAIN = SolutionRegistry.uniqueID();
    public static final int DOWNLOAD_FROM_ANOTHER_SOURCE = SolutionRegistry.uniqueID();
    public static final int DONT_USE_THIS_IMPLEMENTATION = SolutionRegistry.uniqueID();
    public static final int REPORT_AS_BUG = SolutionRegistry.uniqueID();
    public static final int CHECK_PUBLIC_IP_ADDR = SolutionRegistry.uniqueID();
    public static final int CHECK_HOSTNAME_MATCHES_IP_ADDR = SolutionRegistry.uniqueID();
    public static final int CHECK_PORT_ALREADY_IN_USE = SolutionRegistry.uniqueID();
    public static final int USE_ANOTHER_PORT = SolutionRegistry.uniqueID();
    public static final int CHECK_INSTALLATION = SolutionRegistry.uniqueID();
    public static final int CHECK_USERNAME_AND_PASSWORD = SolutionRegistry.uniqueID();
    public static final int CHECK_SSH_SERVER_CONFIG = SolutionRegistry.uniqueID();
    public static final int CHECK_FOR_VALID_PROXY = SolutionRegistry.uniqueID();
    private static SolutionRegistry singleton;
    private static int lastUniqueID;

    static {
        lastUniqueID = 0;
    }

    protected SolutionRegistry() {
    }

    public static SolutionRegistry getRegistry() {
        if (singleton == null) {
            singleton = new SolutionRegistry();
        }
        return singleton;
    }

    public ISolution getSolution(int n) {
        ISolution iSolution = this.findSolution(n);
        if (iSolution == null) {
            Status status = new Status(2, "eu.geclipse.core", 0, String.format(Messages.getString("SolutionRegistry.no_solution_found"), n), null);
            Activator.logStatus((IStatus)status);
        }
        return iSolution;
    }

    protected ISolution findSolution(int n) {
        Solution solution = null;
        if (n == CHECK_AUTH_DATA) {
            solution = new Solution(CHECK_AUTH_DATA, Messages.getString("SolutionRegistry.check_auth_data"));
        } else if (n == CHECK_AUTH_TOKENS) {
            solution = new Solution(CHECK_AUTH_TOKENS, Messages.getString("SolutionRegistry.check_auth_tokens"));
        } else if (n == CHECK_CA_CERTIFICATES) {
            solution = new Solution(CHECK_CA_CERTIFICATES, Messages.getString("SolutionRegistry.check_ca_certificates"));
        } else if (n == CHECK_HOSTNAME_SETTINGS) {
            solution = new Solution(CHECK_HOSTNAME_SETTINGS, Messages.getString("SolutionRegistry.check_hostname_settings"));
        } else if (n == CHECK_INTERNET_CONNECTION) {
            solution = new Solution(CHECK_INTERNET_CONNECTION, Messages.getString("SolutionRegistry.check_internet_connection"));
        } else if (n == CHECK_FIREWALL) {
            solution = new Solution(CHECK_FIREWALL, Messages.getString("SolutionRegistry.check_firewall"));
        } else if (n == CHECK_PROXY_SETTINGS) {
            solution = new Solution(CHECK_PROXY_SETTINGS, Messages.getString("SolutionRegistry.check_proxy_settings"));
        } else if (n == CHECK_SERVER_URL) {
            solution = new Solution(CHECK_SERVER_URL, Messages.getString("SolutionRegistry.check_server_url"));
        } else if (n == CHECK_SYSTEM_TIME) {
            solution = new Solution(CHECK_SYSTEM_TIME, Messages.getString("SolutionRegistry.check_system_time"));
        } else if (n == CHECK_TIMEOUT_SETTINGS) {
            solution = new Solution(CHECK_TIMEOUT_SETTINGS, Messages.getString("SolutionRegistry.check_timeout_settings"));
        } else if (n == CHECK_VO_SETTINGS) {
            solution = new Solution(CHECK_VO_SETTINGS, Messages.getString("SolutionRegistry.check_vo_settings"));
        } else if (n == SERVER_DOWN) {
            solution = new Solution(SERVER_DOWN, Messages.getString("SolutionRegistry.server_down"));
        } else if (n == CONTACT_SERVER_ADMINS) {
            solution = new Solution(CONTACT_SERVER_ADMINS, Messages.getString("SolutionRegistry.contact_server_admins"));
        } else if (n == DOWNLOAD_FILE_AGAIN) {
            solution = new Solution(DOWNLOAD_FILE_AGAIN, Messages.getString("SolutionRegistry.download_file_again"));
        } else if (n == DOWNLOAD_FROM_ANOTHER_SOURCE) {
            solution = new Solution(DOWNLOAD_FROM_ANOTHER_SOURCE, Messages.getString("SolutionRegistry.download_from_another_source"));
        } else if (n == DONT_USE_THIS_IMPLEMENTATION) {
            solution = new Solution(DONT_USE_THIS_IMPLEMENTATION, Messages.getString("SolutionRegistry.dont_use_this_implementation"));
        } else if (n == REPORT_AS_BUG) {
            solution = new Solution(REPORT_AS_BUG, Messages.getString("SolutionRegistry.report_as_bug"));
        } else if (n == CHECK_PUBLIC_IP_ADDR) {
            solution = new Solution(CHECK_PUBLIC_IP_ADDR, Messages.getString("SolutionRegistry.check_public_ip_addr"));
        } else if (n == CHECK_HOSTNAME_MATCHES_IP_ADDR) {
            solution = new Solution(CHECK_HOSTNAME_MATCHES_IP_ADDR, Messages.getString("SolutionRegistry.check_hostname_matches_ip_addr"));
        } else if (n == CHECK_PORT_ALREADY_IN_USE) {
            solution = new Solution(CHECK_PORT_ALREADY_IN_USE, Messages.getString("SolutionRegistry.check_port_already_in_use"));
        } else if (n == USE_ANOTHER_PORT) {
            solution = new Solution(USE_ANOTHER_PORT, Messages.getString("SolutionRegistry.use_another_port"));
        } else if (n == CHECK_INSTALLATION) {
            solution = new Solution(CHECK_INSTALLATION, Messages.getString("SolutionRegistry.check_installation"));
        } else if (n == CHECK_USERNAME_AND_PASSWORD) {
            solution = new Solution(CHECK_USERNAME_AND_PASSWORD, Messages.getString("SolutionRegistry.check_username_and_password"));
        } else if (n == CHECK_SSH_SERVER_CONFIG) {
            solution = new Solution(CHECK_SSH_SERVER_CONFIG, Messages.getString("SolutionRegistry.check_ssh_server_config"));
        } else if (n == CHECK_FOR_VALID_PROXY) {
            solution = new Solution(CHECK_FOR_VALID_PROXY, Messages.getString("SolutionRegistry.checkForValidProxy"));
        }
        return solution;
    }

    protected static int uniqueID() {
        return ++lastUniqueID;
    }
}

