/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.auth;

import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.AuthenticationTokenManager;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.util.SecureFile;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AbstractAuthenticationToken
implements IAuthenticationToken {
    private IAuthenticationTokenDescription description;

    public AbstractAuthenticationToken(IAuthenticationTokenDescription iAuthenticationTokenDescription) {
        this.description = iAuthenticationTokenDescription;
    }

    public static IPath getTokenLocation() {
        SecureFile secureFile;
        IPath iPath = Activator.getDefault().getStateLocation();
        if (!iPath.hasTrailingSeparator()) {
            iPath = iPath.addTrailingSeparator();
        }
        if (!(secureFile = new SecureFile((iPath = iPath.append(".tokens")).toOSString())).exists()) {
            secureFile.mkdir();
        } else {
            try {
                secureFile.setSecure();
            }
            catch (IOException iOException) {}
        }
        return iPath;
    }

    public IAuthenticationTokenDescription getDescription() {
        return this.description;
    }

    public void setActive(boolean bl) throws AuthenticationException {
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        this.setActive(bl, (IProgressMonitor)nullProgressMonitor);
    }

    public void validate() throws AuthenticationException {
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        this.validate((IProgressMonitor)nullProgressMonitor);
    }

    protected void fireTokenStateChanged() {
        AuthenticationTokenManager.getManager().fireContentChanged();
    }

    public IPath getTokenFile() {
        IPath iPath = AbstractAuthenticationToken.getTokenLocation();
        iPath = iPath.addTrailingSeparator().append(this.getID());
        return iPath;
    }
}

