/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.auth;

import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationTokenManager
implements IContentChangeNotifier {
    private static AuthenticationTokenManager singleton = null;
    private List<IAuthenticationToken> tokens = new ArrayList<IAuthenticationToken>();
    private IAuthenticationToken defaultToken;
    private ListenerList ccListeners = new ListenerList();

    private AuthenticationTokenManager() {
    }

    public static AuthenticationTokenManager getManager() {
        if (singleton == null) {
            singleton = new AuthenticationTokenManager();
        }
        return singleton;
    }

    public IAuthenticationToken createToken(IAuthenticationTokenDescription iAuthenticationTokenDescription) throws AuthenticationException {
        IAuthenticationToken iAuthenticationToken = iAuthenticationTokenDescription.createToken();
        this.addToken(iAuthenticationToken);
        return iAuthenticationToken;
    }

    public IAuthenticationToken findToken(IAuthenticationTokenDescription iAuthenticationTokenDescription) {
        IAuthenticationToken iAuthenticationToken = null;
        for (IAuthenticationToken iAuthenticationToken2 : this.tokens) {
            if (!iAuthenticationToken2.getDescription().equals(iAuthenticationTokenDescription)) continue;
            iAuthenticationToken = iAuthenticationToken2;
            break;
        }
        return iAuthenticationToken;
    }

    public List<IAuthenticationToken> getTokens() {
        return new ArrayList<IAuthenticationToken>(this.tokens);
    }

    public void destroyToken(IAuthenticationToken iAuthenticationToken) throws AuthenticationException {
        this.removeToken(iAuthenticationToken);
        iAuthenticationToken.setActive(false);
    }

    public int getTokenCount() {
        return this.tokens.size();
    }

    public boolean isEmpty() {
        return this.getTokenCount() == 0;
    }

    public void setDefaultToken(IAuthenticationToken iAuthenticationToken) {
        if (iAuthenticationToken == null && this.defaultToken != null) {
            this.defaultToken = null;
            this.manageDefaultToken();
            this.fireContentChanged();
        }
        if (this.tokens.contains(iAuthenticationToken) && this.defaultToken != iAuthenticationToken) {
            this.defaultToken = iAuthenticationToken;
            this.fireContentChanged();
        }
    }

    public IAuthenticationToken getDefaultToken() {
        return this.defaultToken;
    }

    public void addContentChangeListener(IContentChangeListener iContentChangeListener) {
        this.ccListeners.add((Object)iContentChangeListener);
    }

    public void removeContentChangeListener(IContentChangeListener iContentChangeListener) {
        this.ccListeners.remove((Object)iContentChangeListener);
    }

    protected void addToken(IAuthenticationToken iAuthenticationToken) {
        this.tokens.add(iAuthenticationToken);
        this.manageDefaultToken();
        this.fireContentChanged();
    }

    protected boolean removeToken(IAuthenticationToken iAuthenticationToken) {
        boolean bl = this.tokens.remove(iAuthenticationToken);
        if (bl) {
            this.manageDefaultToken();
            this.fireContentChanged();
        }
        return bl;
    }

    protected void fireContentChanged() {
        Object[] objectArray = this.ccListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IContentChangeListener) {
                IContentChangeListener iContentChangeListener = (IContentChangeListener)objectArray[n];
                iContentChangeListener.contentChanged((IContentChangeNotifier)this);
            }
            ++n;
        }
    }

    private boolean manageDefaultToken() {
        boolean bl = false;
        if (this.defaultToken != null && !this.tokens.contains(this.defaultToken)) {
            this.defaultToken = null;
            bl = true;
        }
        if (this.defaultToken == null && !this.tokens.isEmpty()) {
            this.defaultToken = this.tokens.get(0);
            bl = true;
        }
        return bl;
    }
}

