/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.auth;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.GridException;
import eu.geclipse.core.auth.ICaCertificate;
import eu.geclipse.core.auth.ICaCertificateLoader;
import eu.geclipse.core.internal.Activator;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;

public class CaCertManager
implements IContentChangeNotifier {
    private static CaCertManager singleton = null;
    private Hashtable<String, ICaCertificate> certs = new Hashtable();
    private ListenerList ccListeners = new ListenerList();

    private CaCertManager() {
        this.update();
        this.fireContentChanged();
    }

    public static CaCertManager getManager() {
        if (singleton == null) {
            singleton = new CaCertManager();
        }
        return singleton;
    }

    public void addCertificate(ICaCertificate iCaCertificate) {
        if (this.internalAddCertificate(iCaCertificate)) {
            this.fireContentChanged();
        }
    }

    public void addCertificates(ICaCertificate[] iCaCertificateArray) {
        boolean bl = false;
        ICaCertificate[] iCaCertificateArray2 = iCaCertificateArray;
        int n = iCaCertificateArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICaCertificate iCaCertificate = iCaCertificateArray2[n2];
            bl |= this.internalAddCertificate(iCaCertificate);
            ++n2;
        }
        if (bl) {
            this.fireContentChanged();
        }
    }

    public ICaCertificate[] getCertificates() {
        return this.certs.values().toArray(new ICaCertificate[0]);
    }

    public ICaCertificate getCertificate(String string) {
        return this.certs.get(string);
    }

    public void deleteCertificate(String string) {
        ICaCertificate iCaCertificate = this.getCertificate(string);
        if (iCaCertificate != null && this.internalDeleteCertificate(iCaCertificate)) {
            this.fireContentChanged();
        }
    }

    public void deleteCertificates(String[] stringArray) {
        boolean bl = false;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            ICaCertificate iCaCertificate = this.getCertificate(string);
            bl |= this.internalDeleteCertificate(iCaCertificate);
            ++n2;
        }
        if (bl) {
            this.fireContentChanged();
        }
    }

    public IPath getCaCertLocation() {
        File file;
        IPath iPath = Activator.getDefault().getStateLocation();
        if (!iPath.hasTrailingSeparator()) {
            iPath = iPath.addTrailingSeparator();
        }
        if (!(file = (iPath = iPath.append(".certs")).toFile()).exists()) {
            file.mkdir();
        }
        return iPath;
    }

    public void addContentChangeListener(IContentChangeListener iContentChangeListener) {
        this.ccListeners.add((Object)iContentChangeListener);
    }

    public void removeContentChangeListener(IContentChangeListener iContentChangeListener) {
        this.ccListeners.remove((Object)iContentChangeListener);
    }

    private void update() {
        String[] stringArray;
        this.certs.clear();
        IPath iPath = this.getCaCertLocation();
        File file = iPath.toFile();
        if (file.isDirectory() && (stringArray = file.list()) != null && stringArray.length > 0) {
            ExtensionManager extensionManager = new ExtensionManager();
            List<Object> list = extensionManager.getExecutableExtensions("eu.geclipse.core.caCertificateLoader", "loader", "class");
            int n = 0;
            while (n < stringArray.length) {
                IPath iPath2 = iPath.append(stringArray[n]);
                for (Object object : list) {
                    ICaCertificateLoader iCaCertificateLoader = (ICaCertificateLoader)object;
                    try {
                        ICaCertificate iCaCertificate = iCaCertificateLoader.getCertificate(iPath2);
                        if (iCaCertificate == null) continue;
                        this.internalAddCertificate(iCaCertificate);
                        break;
                    }
                    catch (GridException gridException) {
                        Activator.logException((Throwable)((Object)gridException));
                    }
                }
                ++n;
            }
        }
    }

    private void fireContentChanged() {
        Object[] objectArray = this.ccListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IContentChangeListener) {
                IContentChangeListener iContentChangeListener = (IContentChangeListener)objectArray[n];
                iContentChangeListener.contentChanged((IContentChangeNotifier)this);
            }
            ++n;
        }
    }

    private boolean internalAddCertificate(ICaCertificate iCaCertificate) {
        boolean bl = false;
        if (iCaCertificate != null) {
            String string = iCaCertificate.getID();
            ICaCertificate iCaCertificate2 = this.getCertificate(string);
            if (iCaCertificate2 != null) {
                this.internalDeleteCertificate(iCaCertificate2);
            }
            try {
                iCaCertificate.write(this.getCaCertLocation());
                this.certs.put(string, iCaCertificate);
                bl = true;
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    private boolean internalDeleteCertificate(ICaCertificate iCaCertificate) {
        boolean bl = false;
        if (iCaCertificate != null) {
            String string = iCaCertificate.getID();
            this.certs.remove(string);
            iCaCertificate.delete(this.getCaCertLocation());
            bl = true;
        }
        return bl;
    }
}

