/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.auth;

import eu.geclipse.core.internal.auth.PEMCertificate;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class EUGridPMACertificate
extends PEMCertificate {
    static final String INFO_FILE_EXTENSION = "info";
    private static final String LIST_FILE_EXTENSION = "eugridpma";
    private static final String INVALID_ID = "N/A";
    private byte[] infoData;

    EUGridPMACertificate(byte[] byArray, byte[] byArray2) {
        super(EUGridPMACertificate.getIDFromInfo(byArray2), byArray);
        Assert.isNotNull((Object)byArray2);
        this.infoData = byArray2;
    }

    static EUGridPMACertificate readFromFile(IPath iPath) throws IOException {
        EUGridPMACertificate eUGridPMACertificate = null;
        if (LIST_FILE_EXTENSION.equals(iPath.getFileExtension())) {
            FileReader fileReader = new FileReader(iPath.toFile());
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                String string = bufferedReader.readLine();
                Path path = new Path(string);
                byte[] byArray = EUGridPMACertificate.read((IPath)path);
                string = bufferedReader.readLine();
                Path path2 = new Path(string);
                byte[] byArray2 = EUGridPMACertificate.read((IPath)path2);
                eUGridPMACertificate = new EUGridPMACertificate(byArray, byArray2);
            }
            finally {
                EUGridPMACertificate.secureClose(bufferedReader);
                EUGridPMACertificate.secureClose(fileReader);
            }
        }
        return eUGridPMACertificate;
    }

    public byte[] getInfoData() {
        return this.infoData;
    }

    public void write(IPath iPath) throws IOException {
        String string = this.getID();
        IPath iPath2 = iPath.append(string);
        IPath iPath3 = iPath2.addFileExtension(LIST_FILE_EXTENSION);
        IPath iPath4 = iPath2.addFileExtension("0");
        IPath iPath5 = iPath2.addFileExtension(INFO_FILE_EXTENSION);
        FileWriter fileWriter = new FileWriter(iPath3.toFile());
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        try {
            bufferedWriter.write(iPath4.toString());
            bufferedWriter.newLine();
            bufferedWriter.write(iPath5.toString());
        }
        finally {
            EUGridPMACertificate.secureClose(bufferedWriter);
            EUGridPMACertificate.secureClose(fileWriter);
        }
        EUGridPMACertificate.write(this.getCertificateData(), iPath4);
        EUGridPMACertificate.write(this.getInfoData(), iPath5);
    }

    protected String[] getFileNames() {
        return new String[]{new Path(this.getID()).addFileExtension(LIST_FILE_EXTENSION).toString(), new Path(this.getID()).addFileExtension("0").toString(), new Path(this.getID()).addFileExtension(INFO_FILE_EXTENSION).toString()};
    }

    private static String getIDFromInfo(byte[] byArray) {
        String string;
        block6: {
            string = INVALID_ID;
            ByteArrayInputStream byteArrayInputStream = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    String string2;
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    inputStreamReader = new InputStreamReader(byteArrayInputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string2 = bufferedReader.readLine()) != null) {
                        String[] stringArray = string2.split("=");
                        String string3 = stringArray[0].trim();
                        if (!string3.equalsIgnoreCase("alias") || stringArray.length <= 1) continue;
                        string = stringArray[1].trim();
                        break;
                    }
                }
                catch (IOException iOException) {
                    EUGridPMACertificate.secureClose(bufferedReader);
                    EUGridPMACertificate.secureClose(inputStreamReader);
                    EUGridPMACertificate.secureClose(byteArrayInputStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                EUGridPMACertificate.secureClose(bufferedReader);
                EUGridPMACertificate.secureClose(inputStreamReader);
                EUGridPMACertificate.secureClose(byteArrayInputStream);
                throw throwable;
            }
            EUGridPMACertificate.secureClose(bufferedReader);
            EUGridPMACertificate.secureClose(inputStreamReader);
            EUGridPMACertificate.secureClose(byteArrayInputStream);
        }
        return string;
    }

    static /* bridge */ /* synthetic */ PEMCertificate readFromFile(IPath iPath) throws IOException {
        return EUGridPMACertificate.readFromFile(iPath);
    }
}

