/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.auth;

import eu.geclipse.core.CoreProblems;
import eu.geclipse.core.GridException;
import eu.geclipse.core.Preferences;
import eu.geclipse.core.auth.ICaCertificate;
import eu.geclipse.core.auth.ICaCertificateLoader;
import eu.geclipse.core.internal.auth.EUGridPMACertificate;
import eu.geclipse.core.internal.auth.Messages;
import eu.geclipse.core.util.tar.TarArchiveException;
import eu.geclipse.core.util.tar.TarEntry;
import eu.geclipse.core.util.tar.TarInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class EUGridPMACertificateLoader
implements ICaCertificateLoader {
    private static final String DEFAULT_LOCATION = "http://www.eugridpma.org/distribution/igtf/current/accredited/tgz";

    public ICaCertificate getCertificate(IPath iPath) throws GridException {
        try {
            return EUGridPMACertificate.readFromFile(iPath);
        }
        catch (IOException iOException) {
            throw new GridException(CoreProblems.UNSPECIFIED_IO_PROBLEM, iOException);
        }
    }

    public ICaCertificate getCertificate(URI uRI, String string, IProgressMonitor iProgressMonitor) throws GridException {
        IProgressMonitor iProgressMonitor2 = iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor;
        iProgressMonitor2.beginTask(String.format(Messages.getString("EUGridPMACertificateLoader.load_cert_task"), string), 3);
        EUGridPMACertificate eUGridPMACertificate = null;
        try {
            try {
                TarEntry tarEntry;
                byte[] byArray = null;
                byte[] byArray2 = null;
                iProgressMonitor2.subTask(Messages.getString("EUGridPMACertificateLoader.contact_server_task"));
                URL uRL = uRI.toURL();
                uRL = new URL(String.valueOf(uRL.toString()) + "/" + string);
                URLConnection uRLConnection = Preferences.getURLConnection(uRL);
                try {
                    uRLConnection.connect();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    throw new GridException(CoreProblems.CONNECTION_TIMEOUT, socketTimeoutException);
                }
                iProgressMonitor2.worked(1);
                iProgressMonitor2.subTask(Messages.getString("EUGridPMACertificateLoader.decomp_file_task"));
                InputStream inputStream = uRLConnection.getInputStream();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                GZIPInputStream gZIPInputStream = new GZIPInputStream(bufferedInputStream);
                TarInputStream tarInputStream = new TarInputStream(gZIPInputStream);
                while ((tarEntry = tarInputStream.getNextEntry()) != null) {
                    if (tarEntry.isDirectory()) continue;
                    IPath iPath = tarEntry.getPath();
                    String string2 = iPath.getFileExtension();
                    if ("0".equalsIgnoreCase(string2)) {
                        byArray = this.readFromStream(tarInputStream);
                        continue;
                    }
                    if (!"info".equalsIgnoreCase(string2)) continue;
                    byArray2 = this.readFromStream(tarInputStream);
                }
                iProgressMonitor2.done();
                iProgressMonitor2.subTask(Messages.getString("EUGridPMACertificateLoader.generate_cert_task"));
                if (byArray != null && byArray2 != null) {
                    eUGridPMACertificate = new EUGridPMACertificate(byArray, byArray2);
                }
                iProgressMonitor2.worked(1);
            }
            catch (IOException iOException) {
                throw new GridException(CoreProblems.CONNECTION_FAILED, iOException);
            }
        }
        finally {
            iProgressMonitor2.done();
        }
        return eUGridPMACertificate;
    }

    public String[] getCertificateList(URI uRI, IProgressMonitor iProgressMonitor) throws GridException {
        IProgressMonitor iProgressMonitor2 = iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor;
        iProgressMonitor2.beginTask(Messages.getString("EUGridPMACertificateLoader.fetch_list_task"), 3);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            try {
                String string;
                iProgressMonitor2.subTask(Messages.getString("EUGridPMACertificateLoader.contact_server_task"));
                URLConnection uRLConnection = Preferences.getURLConnection(uRI.toURL());
                try {
                    uRLConnection.connect();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    throw new GridException(CoreProblems.CONNECTION_TIMEOUT, socketTimeoutException);
                }
                iProgressMonitor2.worked(1);
                iProgressMonitor2.subTask(Messages.getString("EUGridPMACertificateLoader.load_list_task"));
                InputStream inputStream = uRLConnection.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string);
                }
                bufferedReader.close();
                iProgressMonitor2.done();
                iProgressMonitor2.subTask(Messages.getString("EUGridPMACertificateLoader.parse_list_task"));
                String string2 = stringBuffer.toString().replaceAll(" ", "");
                int n = -1;
                while ((n = string2.indexOf("ahref=\"", n + 1)) > 0) {
                    String string3;
                    int n2 = string2.indexOf("\">", n + 7);
                    if (n2 > 0 && (string3 = string2.substring(n + 7, n2)).toLowerCase().endsWith(".tar.gz")) {
                        arrayList.add(string3);
                    }
                    n = n2;
                }
                iProgressMonitor2.done();
            }
            catch (IOException iOException) {
                throw new GridException(CoreProblems.CONNECTION_FAILED, iOException);
            }
        }
        finally {
            iProgressMonitor2.done();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public URI[] getPredefinedRemoteLocations() {
        URI[] uRIArray = null;
        try {
            URI uRI = new URI(DEFAULT_LOCATION);
            uRIArray = new URI[]{uRI};
        }
        catch (URISyntaxException uRISyntaxException) {}
        return uRIArray;
    }

    private byte[] readFromStream(TarInputStream tarInputStream) throws TarArchiveException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        tarInputStream.copyEntryContents(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

