/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.auth;

import eu.geclipse.core.auth.AbstractCaCertificate;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PEMCertificate
extends AbstractCaCertificate {
    static final String PEM_FILE_EXTENSION = "pem";
    static final String CERT_FILE_EXTENSION = "0";
    private static final String LIST_FILE_EXTENSION = "pemcert";

    PEMCertificate(String string, byte[] byArray) {
        super(string, byArray);
    }

    static PEMCertificate readFromFile(IPath iPath) throws IOException {
        PEMCertificate pEMCertificate = null;
        if (CERT_FILE_EXTENSION.equals(iPath.getFileExtension()) || PEM_FILE_EXTENSION.equals(iPath.getFileExtension())) {
            String string = iPath.removeFileExtension().lastSegment();
            byte[] byArray = PEMCertificate.read(iPath);
            pEMCertificate = new PEMCertificate(string, byArray);
        } else if (LIST_FILE_EXTENSION.equals(iPath.getFileExtension())) {
            FileReader fileReader = new FileReader(iPath.toFile());
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                String string = bufferedReader.readLine();
                Path path = new Path(string);
                String string2 = path.removeFileExtension().lastSegment();
                byte[] byArray = PEMCertificate.read((IPath)path);
                pEMCertificate = new PEMCertificate(string2, byArray);
            }
            finally {
                PEMCertificate.secureClose(bufferedReader);
                PEMCertificate.secureClose(fileReader);
            }
        }
        return pEMCertificate;
    }

    protected String[] getFileNames() {
        return new String[]{new Path(this.getID()).addFileExtension(LIST_FILE_EXTENSION).toString(), new Path(this.getID()).addFileExtension(CERT_FILE_EXTENSION).toString()};
    }

    public void write(IPath iPath) throws IOException {
        String string = this.getID();
        IPath iPath2 = iPath.append(string);
        IPath iPath3 = iPath2.addFileExtension(LIST_FILE_EXTENSION);
        IPath iPath4 = iPath2.addFileExtension(CERT_FILE_EXTENSION);
        FileWriter fileWriter = new FileWriter(iPath3.toFile());
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        try {
            bufferedWriter.write(iPath4.toString());
        }
        finally {
            PEMCertificate.secureClose(bufferedWriter);
            PEMCertificate.secureClose(fileWriter);
        }
        PEMCertificate.write(this.getCertificateData(), iPath4);
    }

    protected static byte[] read(IPath iPath) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        File file = iPath.toFile();
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[1024];
        try {
            fileInputStream = new FileInputStream(file);
            int n = fileInputStream.read(byArray);
            while (n != -1) {
                if (n > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                n = fileInputStream.read(byArray);
            }
        }
        catch (Throwable throwable) {
            PEMCertificate.secureClose(fileInputStream);
            throw throwable;
        }
        PEMCertificate.secureClose(fileInputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected static void secureClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected static void secureClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected static void secureClose(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected static void secureClose(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected static void write(byte[] byArray, IPath iPath) throws IOException {
        File file = iPath.toFile();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
        }
        catch (Throwable throwable) {
            PEMCertificate.secureClose(fileOutputStream);
            throw throwable;
        }
        PEMCertificate.secureClose(fileOutputStream);
    }
}

