/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.auth;

import eu.geclipse.core.CoreProblems;
import eu.geclipse.core.GridException;
import eu.geclipse.core.auth.ICaCertificate;
import eu.geclipse.core.auth.ICaCertificateLoader;
import eu.geclipse.core.internal.auth.Messages;
import eu.geclipse.core.internal.auth.PEMCertificate;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class PEMCertificateLoader
implements ICaCertificateLoader {
    public ICaCertificate getCertificate(IPath iPath) throws GridException {
        try {
            return PEMCertificate.readFromFile(iPath);
        }
        catch (IOException iOException) {
            throw new GridException(CoreProblems.UNSPECIFIED_IO_PROBLEM, iOException);
        }
    }

    public ICaCertificate getCertificate(URI uRI, String string, IProgressMonitor iProgressMonitor) throws GridException {
        IProgressMonitor iProgressMonitor2 = iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor;
        iProgressMonitor2.beginTask(String.format(Messages.getString("PEMCertificateLoader.load_cert_task"), string), 1);
        PEMCertificate pEMCertificate = null;
        try {
            try {
                File file = new File(uRI);
                File file2 = new File(file, string);
                Path path = new Path(file2.getPath());
                pEMCertificate = PEMCertificate.readFromFile((IPath)path);
                iProgressMonitor2.worked(1);
            }
            catch (IOException iOException) {
                throw new GridException(CoreProblems.UNSPECIFIED_IO_PROBLEM, iOException);
            }
        }
        finally {
            iProgressMonitor2.done();
        }
        return pEMCertificate;
    }

    public String[] getCertificateList(URI uRI, IProgressMonitor iProgressMonitor) throws GridException {
        File file = new File(uRI);
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                Path path = new Path(string);
                return "0".equals(path.getFileExtension()) || "pem".equals(path.getFileExtension());
            }
        });
        return stringArray;
    }

    public URI[] getPredefinedRemoteLocations() {
        return null;
    }
}

