/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.notify.GridModelEvent;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.GridModelProblems;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.impl.AbstractGridElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractGridElementManager
extends AbstractGridElement
implements IGridElementManager {
    private Hashtable<IPath, IGridElement> elements = new Hashtable();
    private List<IGridModelListener> listeners = new ArrayList<IGridModelListener>();

    protected AbstractGridElementManager() {
    }

    public void addGridModelListener(IGridModelListener iGridModelListener) {
        if (!this.listeners.contains(iGridModelListener)) {
            this.listeners.add(iGridModelListener);
        }
    }

    public boolean canContain(IGridElement iGridElement) {
        return this.canManage(iGridElement);
    }

    public boolean contains(IGridElement iGridElement) {
        return this.elements.values().contains(iGridElement);
    }

    public IGridElement create(IGridElementCreator iGridElementCreator) throws GridModelException {
        IGridElement iGridElement = iGridElementCreator.create(this);
        if (iGridElement != null) {
            this.addElement(iGridElement);
        }
        return iGridElement;
    }

    public void delete(IGridElement iGridElement) {
        if (this.removeElement(iGridElement)) {
            iGridElement.dispose();
        }
    }

    public IGridElement findChild(String string) {
        IGridElement iGridElement = null;
        for (IGridElement iGridElement2 : this.elements.values()) {
            if (!iGridElement2.getName().equals(string)) continue;
            iGridElement = iGridElement2;
            break;
        }
        return iGridElement;
    }

    public IGridElement findChild(IPath iPath) {
        return this.elements.get(iPath);
    }

    public IGridElement findChildWithResource(String string) {
        IGridElement iGridElement = null;
        for (IGridElement iGridElement2 : this.elements.values()) {
            IResource iResource = iGridElement2.getResource();
            if (iResource == null || !iResource.getName().equals(string)) continue;
            iGridElement = iGridElement2;
            break;
        }
        return iGridElement;
    }

    public int getChildCount() {
        return this.elements.size();
    }

    public IGridElement[] getChildren(IProgressMonitor iProgressMonitor) {
        Collection<IGridElement> collection = this.elements.values();
        return collection.toArray(new IGridElement[collection.size()]);
    }

    public boolean hasChildren() {
        return !this.elements.isEmpty();
    }

    public boolean isDirty() {
        return false;
    }

    public IFileStore getFileStore() {
        IFileStore iFileStore = AbstractGridElementManager.getManagerStore();
        IFileStore iFileStore2 = iFileStore.getChild(this.getName());
        IFileInfo iFileInfo = iFileStore2.fetchInfo();
        if (!iFileInfo.exists()) {
            try {
                iFileStore2.mkdir(0, null);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
        }
        return iFileStore2;
    }

    public static IFileStore getManagerStore() {
        IPath iPath = Activator.getDefault().getStateLocation();
        return EFS.getLocalFileSystem().getStore(iPath);
    }

    public IGridContainer getParent() {
        return GridModel.getRoot();
    }

    public IPath getPath() {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath iPath = iWorkspaceRoot.getFullPath();
        return iPath.append(this.getName());
    }

    public IGridProject getProject() {
        return null;
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLazy() {
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public void refresh(IProgressMonitor iProgressMonitor) {
    }

    public void removeGridModelListener(IGridModelListener iGridModelListener) {
        this.listeners.remove(iGridModelListener);
    }

    public void setDirty() {
    }

    public boolean addElement(IGridElement iGridElement) throws GridModelException {
        boolean bl = false;
        this.testCanManage(iGridElement);
        IPath iPath = iGridElement.getPath();
        IGridElement iGridElement2 = this.findChild(iPath);
        if (iGridElement != iGridElement2) {
            if (iGridElement2 != null) {
                this.delete(iGridElement2);
            }
            this.elements.put(iPath, iGridElement);
            GridModelEvent gridModelEvent = new GridModelEvent(1, this, new IGridElement[]{iGridElement});
            this.fireGridModelEvent(gridModelEvent);
            bl = true;
        }
        return bl;
    }

    public boolean removeElement(IGridElement iGridElement) {
        boolean bl;
        IPath iPath = iGridElement.getPath();
        boolean bl2 = bl = this.elements.remove(iPath) != null;
        if (bl) {
            GridModelEvent gridModelEvent = new GridModelEvent(2, this, new IGridElement[]{iGridElement});
            this.fireGridModelEvent(gridModelEvent);
        }
        return bl;
    }

    protected void fireGridModelEvent(IGridModelEvent iGridModelEvent) {
        for (IGridModelListener iGridModelListener : this.listeners) {
            iGridModelListener.gridModelChanged(iGridModelEvent);
        }
    }

    protected void testCanManage(IGridElement iGridElement) throws GridModelException {
        if (!this.canManage(iGridElement)) {
            throw new GridModelException(GridModelProblems.ELEMENT_NOT_MANAGEABLE);
        }
    }
}

