/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.VoManager;
import eu.geclipse.core.internal.model.VoWrapper;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import eu.geclipse.core.project.GridProjectNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class GridProject
extends ResourceGridContainer
implements IGridProject {
    private static final String PROJECT_NODE = "eu.geclipse.core";
    private static final String VO_ATTRIBUTE = "vo";
    private IVirtualOrganization vo;

    protected GridProject(IProject iProject) {
        super((IResource)iProject);
        this.loadProjectProperties(iProject);
    }

    public boolean canContain(IGridElement iGridElement) {
        return true;
    }

    public IGridElement[] getChildren(IProgressMonitor iProgressMonitor) throws GridModelException {
        IGridElement[] iGridElementArray = new IGridElement[]{};
        if (this.isOpen() && !this.hasVo(iGridElementArray = super.getChildren(iProgressMonitor))) {
            this.loadProjectProperties((IProject)this.getResource());
            iGridElementArray = super.getChildren(iProgressMonitor);
        }
        return iGridElementArray;
    }

    public int getChildCount() {
        int n = 0;
        if (this.isOpen()) {
            n = super.getChildCount();
        }
        return n;
    }

    public IGridProject getProject() {
        return this;
    }

    public IVirtualOrganization getVO() {
        return this.vo;
    }

    public boolean isGridProject() {
        boolean bl = false;
        IProject iProject = (IProject)this.getResource();
        try {
            bl = iProject.hasNature(GridProjectNature.getID());
        }
        catch (CoreException coreException) {}
        return bl;
    }

    public boolean isOpen() {
        return ((IProject)this.getResource()).isOpen();
    }

    protected boolean fetchChildren(IProgressMonitor iProgressMonitor) {
        boolean bl = false;
        if (this.isOpen()) {
            bl = super.fetchChildren(iProgressMonitor);
        }
        return bl;
    }

    private boolean hasVo(IGridElement[] iGridElementArray) {
        boolean bl = false;
        IGridElement[] iGridElementArray2 = iGridElementArray;
        int n = iGridElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement iGridElement = iGridElementArray2[n2];
            if (iGridElement instanceof VoWrapper) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    private void loadProjectProperties(IProject iProject) {
        ProjectScope projectScope = new ProjectScope(iProject);
        IEclipsePreferences iEclipsePreferences = projectScope.getNode(PROJECT_NODE);
        try {
            iEclipsePreferences.sync();
            String string = iEclipsePreferences.get(VO_ATTRIBUTE, null);
            this.vo = null;
            VoManager voManager = VoManager.getManager();
            if (string != null) {
                this.vo = (IVirtualOrganization)voManager.findChild(string);
                if (this.vo != null) {
                    this.addElement(new VoWrapper(this, this.vo));
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            Activator.logException(backingStoreException);
        }
        catch (GridModelException gridModelException) {
            Activator.logException((Throwable)((Object)gridModelException));
        }
    }
}

