/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.JobManager;
import eu.geclipse.core.internal.model.notify.GridNotificationService;
import eu.geclipse.core.internal.model.notify.ResourceNotificationService;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.core.model.IManageable;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public final class GridRoot
extends ResourceGridContainer
implements IGridRoot {
    private static GridRoot singleton;

    private GridRoot() {
        super((IResource)ResourcesPlugin.getWorkspace().getRoot());
        this.addGridModelListener(JobManager.getManager());
        GridRoot.getGridNotificationService();
        GridRoot.getResourceNotificationService();
    }

    public static final GridRoot getInstance() {
        if (singleton == null) {
            singleton = new GridRoot();
        }
        return singleton;
    }

    public static GridNotificationService getGridNotificationService() {
        return GridNotificationService.getInstance();
    }

    public IGridContainer getParent() {
        return null;
    }

    public static ResourceNotificationService getResourceNotificationService() {
        return ResourceNotificationService.getInstance();
    }

    public static final GridRoot getRoot() {
        return singleton;
    }

    public void addGridModelListener(IGridModelListener iGridModelListener) {
        GridRoot.getGridNotificationService().addListener(iGridModelListener);
    }

    public boolean canContain(IGridElement iGridElement) {
        return iGridElement instanceof IGridProject;
    }

    public final IGridElement findElement(IPath iPath) {
        IGridElement iGridElement = iPath.isRoot() ? this : null;
        String[] stringArray = iPath.segments();
        IGridContainer iGridContainer = this;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            iGridElement = iGridContainer.findChild(string);
            if (!(iGridElement instanceof IGridContainer)) break;
            iGridContainer = iGridElement;
            ++n2;
        }
        return iGridElement;
    }

    public final IGridElement findElement(IResource iResource) {
        IGridElement iGridElement = null;
        IPath iPath = iResource.getFullPath();
        if (iPath.segmentCount() == 0 && !iPath.isEmpty()) {
            iGridElement = GridModel.getRoot();
        } else {
            IGridContainer iGridContainer = this;
            int n = 0;
            while (n < iPath.segmentCount()) {
                String string = iPath.segment(n);
                IGridElement iGridElement2 = iGridContainer.findChildWithResource(string);
                if (n == iPath.segmentCount() - 1) {
                    iGridElement = iGridElement2;
                } else if (iGridElement2 instanceof IGridContainer) {
                    iGridContainer = (IGridContainer)iGridElement2;
                }
                ++n;
            }
        }
        return iGridElement;
    }

    public void fireGridModelEvent(IGridModelEvent iGridModelEvent) {
        GridRoot.getGridNotificationService().queueEvent(iGridModelEvent);
    }

    public static void registerElement(IGridElement iGridElement) {
        if (iGridElement instanceof IManageable) {
            IGridElementManager iGridElementManager = ((IManageable)iGridElement).getManager();
            try {
                iGridElementManager.addElement(iGridElement);
            }
            catch (GridModelException gridModelException) {
                Activator.logException((Throwable)((Object)gridModelException));
            }
        }
    }

    public void removeGridModelListener(IGridModelListener iGridModelListener) {
        GridRoot.getGridNotificationService().removeListener(iGridModelListener);
    }
}

