/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.model.Messages;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridTransfer;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GridTransfer
extends AbstractGridContainer
implements IGridTransfer {
    private IGridTransfer parent;
    private IGridElement source;

    protected GridTransfer(GridTransfer gridTransfer, IGridElement iGridElement) {
        this.parent = gridTransfer;
        this.source = iGridElement;
    }

    public boolean canContain(IGridElement iGridElement) {
        return iGridElement instanceof IGridTransfer;
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(this.getName());
    }

    public String getName() {
        return this.source.getName();
    }

    public IGridContainer getParent() {
        return this.parent;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(this.getName());
    }

    public IResource getResource() {
        return null;
    }

    public IGridElement getSource() {
        return this.source;
    }

    public IGridContainer getTarget() {
        return ((IGridTransfer)this.getParent()).getTarget();
    }

    public boolean isAtomic() {
        return this.source != null;
    }

    public boolean isLazy() {
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    protected void prepareTransfer(IProgressMonitor iProgressMonitor) throws GridModelException {
        IProgressMonitor iProgressMonitor2 = iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor;
        iProgressMonitor2.beginTask(String.valueOf(Messages.getString("GridTransfer.preparing_transfer_progress")) + this.getName(), 10);
        try {
            this.deleteAll();
            if (this.source instanceof IGridContainer) {
                IGridElement[] iGridElementArray;
                IGridContainer iGridContainer = (IGridContainer)this.source;
                IGridElement[] iGridElementArray2 = iGridElementArray = iGridContainer.getChildren((IProgressMonitor)new SubProgressMonitor(iProgressMonitor2, 1));
                int n = iGridElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement iGridElement = iGridElementArray2[n2];
                    GridTransfer gridTransfer = new GridTransfer(this, iGridElement);
                    this.addElement(gridTransfer);
                    gridTransfer.prepareTransfer((IProgressMonitor)new SubProgressMonitor(iProgressMonitor2, 9));
                    ++n2;
                }
            }
        }
        finally {
            iProgressMonitor2.done();
        }
    }
}

