/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.GridTransfer;
import eu.geclipse.core.internal.model.Messages;
import eu.geclipse.core.internal.model.TransferManager;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GridTransferRoot
extends GridTransfer {
    private static final String TRANSFER_QUALIFIER = "transfer@";
    private String name;
    private IGridContainer target;

    public GridTransferRoot(IGridElement[] iGridElementArray, IGridContainer iGridContainer) {
        super(null, null);
        this.target = iGridContainer;
        this.name = TRANSFER_QUALIFIER + System.currentTimeMillis();
        IGridElement[] iGridElementArray2 = iGridElementArray;
        int n = iGridElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement iGridElement = iGridElementArray2[n2];
            try {
                GridTransfer gridTransfer = new GridTransfer(this, iGridElement);
                this.addElement(gridTransfer);
            }
            catch (GridModelException gridModelException) {
                Activator.logException((Throwable)((Object)gridModelException));
            }
            ++n2;
        }
    }

    public IFileStore getFileStore() {
        return TransferManager.getTransferManagerStore().getChild(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public IGridContainer getParent() {
        return TransferManager.getManager();
    }

    public IGridContainer getTarget() {
        return this.target;
    }

    public void startTransfer() {
    }

    protected void prepareTransfer(IProgressMonitor iProgressMonitor) throws GridModelException {
        IProgressMonitor iProgressMonitor2 = iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor;
        iProgressMonitor2.beginTask(Messages.getString("GridTransferRoot.preparing_transfer_progress"), this.getChildCount());
        try {
            IGridElement[] iGridElementArray;
            IGridElement[] iGridElementArray2 = iGridElementArray = this.getChildren(null);
            int n = iGridElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement iGridElement = iGridElementArray2[n2];
                GridTransfer gridTransfer = (GridTransfer)iGridElement;
                gridTransfer.prepareTransfer((IProgressMonitor)new SubProgressMonitor(iProgressMonitor2, 1));
                ++n2;
            }
        }
        finally {
            iProgressMonitor2.done();
        }
    }
}

