/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.GridModelProblems;
import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridPreferences;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import java.net.URI;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class HiddenProject
extends ResourceGridContainer
implements IGridProject,
IGridPreferences {
    public static final String NAME = ".geclipse";
    private static final String DIR_GLOBAL_CONNECTIONS = ".connections";
    private static final String DIR_TEMP = ".temp";
    private static final String TEMP_CONNECTION_NAME = ".tmp_connection";

    private HiddenProject(IProject iProject) {
        super((IResource)iProject);
    }

    public static HiddenProject getInstance() throws GridModelException {
        IGridRoot iGridRoot = GridModel.getRoot();
        HiddenProject hiddenProject = (HiddenProject)iGridRoot.findChild(NAME);
        if (hiddenProject == null) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String string = NAME;
            IProject iProject = iWorkspaceRoot.getProject(string);
            hiddenProject = HiddenProject.getInstance(iProject);
        }
        return hiddenProject;
    }

    static HiddenProject getInstance(IProject iProject) throws GridModelException {
        if (!iProject.exists()) {
            String string = iProject.getName();
            IPath iPath = null;
            IStatus iStatus = ResourcesPlugin.getWorkspace().validateProjectLocation(iProject, iPath);
            if (iStatus.getSeverity() != 0) {
                throw new GridModelException(GridModelProblems.PREFERENCE_CREATION_FAILED, iStatus.getException(), iStatus.getMessage());
            }
            IProjectDescription iProjectDescription = iProject.getWorkspace().newProjectDescription(string);
            iProjectDescription.setLocation(iPath);
            try {
                iProject.create(iProjectDescription, null);
            }
            catch (CoreException coreException) {
                throw new GridModelException(GridModelProblems.PREFERENCE_CREATION_FAILED, coreException);
            }
        }
        return new HiddenProject(iProject);
    }

    public boolean canContain(IGridElement iGridElement) {
        return true;
    }

    public void createGlobalConnection(String string, URI uRI) throws GridModelException {
        try {
            IFolder iFolder = this.getGlobalConnectionsFolder();
            IFolder iFolder2 = iFolder.getFolder(string);
            iFolder2.createLink(uRI, 16, null);
        }
        catch (CoreException coreException) {
            throw new GridModelException(GridModelProblems.ELEMENT_CREATE_FAILED, coreException);
        }
    }

    public IGridConnection createTemporaryConnection(URI uRI) throws GridModelException {
        IGridConnection iGridConnection = null;
        try {
            IFolder iFolder = this.getTemporaryFolder();
            IFolder iFolder2 = iFolder.getFolder(TEMP_CONNECTION_NAME);
            if (iFolder2.exists()) {
                iFolder2.delete(true, null);
            }
            iFolder2.createLink(uRI, 272, null);
            iGridConnection = (IGridConnection)GridModel.getConnectionManager().findChild(TEMP_CONNECTION_NAME);
        }
        catch (CoreException coreException) {
            throw new GridModelException(GridModelProblems.ELEMENT_CREATE_FAILED, coreException);
        }
        return iGridConnection;
    }

    public IGridProject getProject() {
        return this;
    }

    public IVirtualOrganization getVO() {
        return null;
    }

    public boolean isGridProject() {
        return false;
    }

    public boolean isOpen() {
        return ((IProject)this.getResource()).isOpen();
    }

    protected boolean fetchChildren(IProgressMonitor iProgressMonitor) {
        boolean bl = false;
        if (this.isOpen()) {
            bl = super.fetchChildren(iProgressMonitor);
        }
        return bl;
    }

    protected IProject getAccessibleProject() throws CoreException {
        IProject iProject = (IProject)this.getResource();
        if (!iProject.isOpen()) {
            iProject.open(null);
        }
        return iProject;
    }

    protected IFolder getGlobalConnectionsFolder() throws CoreException {
        IFolder iFolder = this.getProjectFolder(DIR_GLOBAL_CONNECTIONS);
        return iFolder;
    }

    protected IFolder getTemporaryFolder() throws CoreException {
        IFolder iFolder = this.getProjectFolder(DIR_TEMP);
        return iFolder;
    }

    private IFolder getProjectFolder(String string) throws CoreException {
        IProject iProject = this.getAccessibleProject();
        IFolder iFolder = iProject.getFolder((IPath)new Path(string));
        if (!iFolder.exists()) {
            iFolder.create(1, true, null);
        }
        return iFolder;
    }
}

