/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.JobStatusUpdater;
import eu.geclipse.core.internal.model.AbstractGridElementManager;
import eu.geclipse.core.internal.model.JobScheduler;
import eu.geclipse.core.internal.model.Messages;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobManager;
import eu.geclipse.core.model.IGridJobStatusListener;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobManager
extends AbstractGridElementManager
implements IGridJobManager,
IGridJobStatusListener,
IGridModelListener {
    private static final String NAME = ".jobs";
    private static JobManager singleton;
    Hashtable<IGridJobID, JobStatusUpdater> updaters = new Hashtable();
    private List<IGridJobStatusListener> globalListeners = new ArrayList<IGridJobStatusListener>();

    private JobManager() {
    }

    @Override
    public boolean addElement(IGridElement iGridElement) throws GridModelException {
        boolean bl = super.addElement(iGridElement);
        if (iGridElement instanceof IGridJob) {
            JobStatusUpdater jobStatusUpdater = new JobStatusUpdater((IGridJob)iGridElement);
            this.updaters.put(((IGridJob)iGridElement).getID(), jobStatusUpdater);
            jobStatusUpdater.setSystem(true);
            JobScheduler.getJobScheduler().scheduleNewUpdater(jobStatusUpdater);
            jobStatusUpdater.addJobStatusListener(255, this);
            if (((IGridJob)iGridElement).getID().getJobID().equals(Messages.getString("JobManager.UNKNOWN_STRING"))) {
                Thread thread = new Thread(){
                    private boolean found = false;

                    public void run() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        Enumeration<IGridJobID> enumeration = JobManager.this.updaters.keys();
                        while (enumeration.hasMoreElements() && !this.found) {
                            IGridJobID iGridJobID = enumeration.nextElement();
                            if (!iGridJobID.getJobID().equals(Messages.getString("JobManager.UNKNOWN_STRING"))) continue;
                            this.found = true;
                            JobStatusUpdater jobStatusUpdater = JobManager.this.updaters.get(iGridJobID);
                            if (jobStatusUpdater == null) continue;
                            JobManager.this.updaters.remove(iGridJobID);
                            JobManager.this.updaters.put(jobStatusUpdater.getJob().getID(), jobStatusUpdater);
                        }
                    }
                };
                thread.start();
            }
        }
        return bl;
    }

    @Override
    public void startUpdater(IGridJobID iGridJobID) throws GridModelException {
        JobStatusUpdater jobStatusUpdater = new JobStatusUpdater(iGridJobID);
        this.updaters.put(iGridJobID, jobStatusUpdater);
        jobStatusUpdater.setSystem(true);
        JobScheduler.getJobScheduler().scheduleNewUpdater(jobStatusUpdater);
    }

    @Override
    public void pauseAllUpdaters() {
        JobScheduler.getJobScheduler().pauseAllUpdaters();
    }

    public void pauseUpdater(JobStatusUpdater jobStatusUpdater) {
        JobScheduler.getJobScheduler().pauseUpdater(jobStatusUpdater);
    }

    public void pauseUpdater(IGridJobID iGridJobID) {
        JobStatusUpdater jobStatusUpdater = this.updaters.get(iGridJobID);
        if (jobStatusUpdater != null) {
            JobScheduler.getJobScheduler().pauseUpdater(jobStatusUpdater);
        }
    }

    @Override
    public void wakeUpAllUpdaters() {
        JobScheduler.getJobScheduler().resumeAllUpdaters();
    }

    @Override
    public void updateJobsStatus(ArrayList<IGridJob> arrayList) {
        Enumeration<IGridJobID> enumeration = this.updaters.keys();
        while (enumeration.hasMoreElements()) {
            IGridJobID iGridJobID = enumeration.nextElement();
            for (IGridJob iGridJob : arrayList) {
                if (iGridJobID != iGridJob.getID()) continue;
                JobStatusUpdater jobStatusUpdater = this.updaters.get(iGridJobID);
                jobStatusUpdater.sleep();
                jobStatusUpdater.wakeUp();
                jobStatusUpdater.schedule(1000L);
            }
        }
    }

    public static JobManager getManager() {
        if (singleton == null) {
            singleton = new JobManager();
        }
        return singleton;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean canManage(IGridElement iGridElement) {
        return iGridElement instanceof IGridJob;
    }

    @Override
    public void addJobStatusListener(IGridJobStatusListener iGridJobStatusListener) {
        if (!this.globalListeners.contains(iGridJobStatusListener)) {
            this.globalListeners.add(iGridJobStatusListener);
        }
    }

    @Override
    public void addJobStatusListener(IGridJob[] iGridJobArray, int n, IGridJobStatusListener iGridJobStatusListener) {
        IGridJob[] iGridJobArray2 = iGridJobArray;
        int n2 = iGridJobArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IGridJob iGridJob = iGridJobArray2[n3];
            for (JobStatusUpdater jobStatusUpdater : this.updaters.values()) {
                if (!jobStatusUpdater.getJob().equals(iGridJob)) continue;
                jobStatusUpdater.addJobStatusListener(n, iGridJobStatusListener);
            }
            ++n3;
        }
    }

    @Override
    public void addJobStatusListener(IGridJobID[] iGridJobIDArray, int n, IGridJobStatusListener iGridJobStatusListener) {
        IGridJobID[] iGridJobIDArray2 = iGridJobIDArray;
        int n2 = iGridJobIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IGridJobID iGridJobID = iGridJobIDArray2[n3];
            JobStatusUpdater jobStatusUpdater = this.updaters.get(iGridJobID);
            jobStatusUpdater.addJobStatusListener(n, iGridJobStatusListener);
            ++n3;
        }
    }

    @Override
    public void removeJobStatusListener(IGridJobStatusListener iGridJobStatusListener) {
        Enumeration<JobStatusUpdater> enumeration = this.updaters.elements();
        while (enumeration.hasMoreElements()) {
            JobStatusUpdater jobStatusUpdater = enumeration.nextElement();
            jobStatusUpdater.removeJobStatusListener(iGridJobStatusListener);
        }
        this.globalListeners.remove(iGridJobStatusListener);
    }

    public void removeUpdater(JobStatusUpdater jobStatusUpdater) {
        Collection<JobStatusUpdater> collection = this.updaters.values();
        while (collection.remove((Object)jobStatusUpdater)) {
            JobScheduler.getJobScheduler().clearUpdater(jobStatusUpdater);
        }
    }

    @Override
    public void statusChanged(IGridJob iGridJob) {
        for (IGridJobStatusListener iGridJobStatusListener : this.globalListeners) {
            iGridJobStatusListener.statusChanged(iGridJob);
        }
    }

    void waitForJob(IGridJob iGridJob) throws InterruptedException, NoSuchElementException {
        JobStatusUpdater jobStatusUpdater = this.updaters.get(iGridJob.getID());
        if (jobStatusUpdater == null) {
            throw new NoSuchElementException();
        }
        jobStatusUpdater.join();
    }

    void waitForJob(IGridJobID iGridJobID) throws InterruptedException, NoSuchElementException {
        JobStatusUpdater jobStatusUpdater = this.updaters.get(iGridJobID);
        if (jobStatusUpdater == null) {
            throw new NoSuchElementException();
        }
        jobStatusUpdater.join();
    }

    public void removeJobStatusListener(IGridJob[] iGridJobArray, IGridJobStatusListener iGridJobStatusListener) {
        int n = 0;
        while (n < iGridJobArray.length) {
            JobStatusUpdater jobStatusUpdater = this.updaters.get(iGridJobArray[n].getID());
            jobStatusUpdater.removeJobStatusListener(iGridJobStatusListener);
            ++n;
        }
        this.globalListeners.remove(iGridJobStatusListener);
    }

    public void removeJobStatusListener(IGridJobID[] iGridJobIDArray, IGridJobStatusListener iGridJobStatusListener) {
        int n = 0;
        while (n < iGridJobIDArray.length) {
            JobStatusUpdater jobStatusUpdater = this.updaters.get(iGridJobIDArray[n]);
            jobStatusUpdater.removeJobStatusListener(iGridJobStatusListener);
            ++n;
        }
        this.globalListeners.remove(iGridJobStatusListener);
    }

    @Override
    public void gridModelChanged(IGridModelEvent iGridModelEvent) {
        if (iGridModelEvent.getType() == 2) {
            IGridElement[] iGridElementArray;
            IGridElement[] iGridElementArray2 = iGridElementArray = iGridModelEvent.getElements();
            int n = iGridElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement iGridElement = iGridElementArray2[n2];
                if (iGridElement instanceof IGridJob) {
                    IGridJob iGridJob = (IGridJob)iGridElement;
                    JobStatusUpdater jobStatusUpdater = this.updaters.get(iGridJob.getID());
                    while (jobStatusUpdater.getState() == 4) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    jobStatusUpdater.cancel();
                    this.removeUpdater(jobStatusUpdater);
                }
                ++n2;
            }
        }
    }

    @Override
    public void jobStatusChanged(IGridJob iGridJob) {
        JobStatusUpdater jobStatusUpdater = this.updaters.get(iGridJob.getID());
        if (jobStatusUpdater != null) {
            jobStatusUpdater.statusUpdated(iGridJob.getJobStatus());
        }
    }
}

