/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.JobStatusUpdater;
import eu.geclipse.core.Preferences;
import eu.geclipse.core.internal.model.Messages;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class JobScheduler
extends Job {
    public static final int UPDATER_NORMAL_PRIORITY = 1;
    public static final int UPDATER_HIGH_PRIORITY = 2;
    private static JobScheduler singleton;
    private Hashtable<JobStatusUpdater, Integer> sleepingUpdaters = new Hashtable();
    private Hashtable<JobStatusUpdater, Integer> workingUpdaters = new Hashtable();

    public JobScheduler(String string) {
        super(Messages.getString("JobManager.scheduler_name"));
        this.schedule(30000L);
    }

    public int getNumberOfRunningUpdaters() {
        return this.workingUpdaters.size();
    }

    public static JobScheduler getJobScheduler() {
        if (singleton == null) {
            singleton = new JobScheduler("");
        }
        return singleton;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) {
        JobStatusUpdater jobStatusUpdater;
        if (Preferences.getUpdateJobsStatus() && this.sleepingUpdaters.size() > 0 && this.getNumberOfRunningUpdaters() < Preferences.getUpdatersLimit()) {
            jobStatusUpdater = null;
            if (this.sleepingUpdaters.contains(new Integer(2))) {
                JobStatusUpdater jobStatusUpdater2 = null;
                Enumeration<JobStatusUpdater> enumeration = this.sleepingUpdaters.keys();
                while (enumeration.hasMoreElements()) {
                    jobStatusUpdater2 = enumeration.nextElement();
                    if (this.sleepingUpdaters.get((Object)jobStatusUpdater2) != 2) continue;
                    jobStatusUpdater = jobStatusUpdater2;
                }
                if (jobStatusUpdater != null) {
                    jobStatusUpdater.wakeUp();
                    jobStatusUpdater.schedule(Preferences.getUpdateJobsPeriod());
                }
            } else {
                jobStatusUpdater = this.sleepingUpdaters.keys().nextElement();
                jobStatusUpdater.wakeUp();
                jobStatusUpdater.schedule(Preferences.getUpdateJobsPeriod());
            }
            this.workingUpdaters.put(jobStatusUpdater, new Integer(1));
            this.sleepingUpdaters.remove((Object)jobStatusUpdater);
        }
        while (this.getNumberOfRunningUpdaters() > Preferences.getUpdatersLimit()) {
            jobStatusUpdater = this.workingUpdaters.keys().nextElement();
            this.pauseUpdater(jobStatusUpdater);
        }
        this.schedule(30000L);
        return Status.OK_STATUS;
    }

    public void scheduleNewUpdater(JobStatusUpdater jobStatusUpdater) {
        if (Preferences.getUpdateJobsStatus() && this.getNumberOfRunningUpdaters() < Preferences.getUpdatersLimit()) {
            int n = Preferences.getUpdateJobsPeriod();
            jobStatusUpdater.schedule(n);
            this.workingUpdaters.put(jobStatusUpdater, new Integer(1));
        } else {
            this.sleepingUpdaters.put(jobStatusUpdater, new Integer(1));
        }
    }

    public void pauseAllUpdaters() {
        Enumeration<JobStatusUpdater> enumeration = this.workingUpdaters.keys();
        while (enumeration.hasMoreElements()) {
            JobStatusUpdater jobStatusUpdater = enumeration.nextElement();
            this.pauseUpdater(jobStatusUpdater);
        }
    }

    public boolean pauseUpdater(JobStatusUpdater jobStatusUpdater) {
        boolean bl = false;
        if (this.workingUpdaters.containsKey((Object)jobStatusUpdater)) {
            bl = true;
            jobStatusUpdater.sleep();
            this.sleepingUpdaters.put(jobStatusUpdater, new Integer(1));
            this.workingUpdaters.remove((Object)jobStatusUpdater);
        }
        return bl;
    }

    public void resumeAllUpdaters() {
        Enumeration<JobStatusUpdater> enumeration = this.sleepingUpdaters.keys();
        while (enumeration.hasMoreElements()) {
            JobStatusUpdater jobStatusUpdater = enumeration.nextElement();
            this.resumeUpdater(jobStatusUpdater);
        }
    }

    public boolean resumeUpdater(JobStatusUpdater jobStatusUpdater) {
        boolean bl = false;
        if (this.sleepingUpdaters.containsKey((Object)jobStatusUpdater)) {
            bl = true;
            jobStatusUpdater.wakeUp();
            this.workingUpdaters.put(jobStatusUpdater, new Integer(1));
            this.sleepingUpdaters.remove((Object)jobStatusUpdater);
        }
        return bl;
    }

    public void clearUpdater(JobStatusUpdater jobStatusUpdater) {
        this.sleepingUpdaters.remove((Object)jobStatusUpdater);
        this.workingUpdaters.remove((Object)jobStatusUpdater);
    }
}

