/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.AbstractGridElementManager;
import eu.geclipse.core.internal.model.GridTransferRoot;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridTransfer;
import eu.geclipse.core.model.ITransferManager;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;

public class TransferManager
extends AbstractGridElementManager
implements ITransferManager {
    public static final String NAME = ".transfers";
    private static TransferManager singleton;

    private TransferManager() {
        try {
            this.loadElements();
        }
        catch (GridModelException gridModelException) {
            Activator.logException((Throwable)((Object)gridModelException));
        }
    }

    public static TransferManager getManager() {
        if (singleton == null) {
            singleton = new TransferManager();
        }
        return singleton;
    }

    public static IFileStore getTransferManagerStore() {
        IFileStore iFileStore = TransferManager.getManagerStore();
        IFileStore iFileStore2 = iFileStore.getChild(NAME);
        IFileInfo iFileInfo = iFileStore2.fetchInfo();
        if (!iFileInfo.exists()) {
            try {
                iFileStore2.mkdir(0, null);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
        }
        return iFileStore2;
    }

    public boolean canManage(IGridElement iGridElement) {
        return iGridElement instanceof IGridTransfer;
    }

    public String getName() {
        return NAME;
    }

    public void loadElements() throws GridModelException {
    }

    public void saveElements() throws GridModelException {
    }

    public void queueTransfer(IGridElement[] iGridElementArray, IGridContainer iGridContainer) throws GridModelException {
        GridTransferRoot gridTransferRoot = new GridTransferRoot(iGridElementArray, iGridContainer);
        this.addElement(gridTransferRoot);
        gridTransferRoot.startTransfer();
    }
}

