/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.Preferences;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.AbstractDefaultGridElementManager;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.GridModelProblems;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.IStorableElementCreator;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IVoManager;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;

public class VoManager
extends AbstractDefaultGridElementManager
implements IVoManager {
    public static final String NAME = ".vos";
    private static VoManager singleton;

    private VoManager() {
        try {
            this.loadElements();
        }
        catch (GridModelException gridModelException) {
            Activator.logException((Throwable)((Object)gridModelException));
        }
    }

    public static VoManager getManager() {
        if (singleton == null) {
            singleton = new VoManager();
        }
        return singleton;
    }

    public static IFileStore getVoManagerStore() {
        IFileStore iFileStore = VoManager.getManagerStore();
        IFileStore iFileStore2 = iFileStore.getChild(NAME);
        IFileInfo iFileInfo = iFileStore2.fetchInfo();
        if (!iFileInfo.exists()) {
            try {
                iFileStore2.mkdir(0, null);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
        }
        return iFileStore2;
    }

    public boolean canManage(IGridElement iGridElement) {
        return iGridElement instanceof IVirtualOrganization;
    }

    public String getName() {
        return NAME;
    }

    public void loadElements() throws GridModelException {
        String string;
        IFileStore[] iFileStoreArray;
        IFileStore iFileStore = this.getFileStore();
        try {
            iFileStoreArray = iFileStore.childStores(0, null);
        }
        catch (CoreException coreException) {
            throw new GridModelException(GridModelProblems.ELEMENT_LOAD_FAILED, coreException);
        }
        IFileStore[] iFileStoreArray2 = iFileStoreArray;
        int n = iFileStoreArray.length;
        int n2 = 0;
        while (n2 < n) {
            string = iFileStoreArray2[n2];
            IStorableElementCreator iStorableElementCreator = GridModel.getStorableElementCreator((IFileStore)string);
            if (iStorableElementCreator != null) {
                this.create(iStorableElementCreator);
            }
            ++n2;
        }
        string = Preferences.getDefaultVoName();
        if (string != null) {
            IGridElement iGridElement = this.findChild(string);
            this.setDefault(iGridElement);
        }
        if (this.hasChildren()) {
            this.updateDefault();
        }
    }

    public void saveElements() throws GridModelException {
        IGridElement iGridElement;
        IGridElement[] iGridElementArray;
        IGridElement[] iGridElementArray2 = iGridElementArray = this.getChildren(null);
        int n = iGridElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            iGridElement = iGridElementArray2[n2];
            if (iGridElement instanceof IStorableElement) {
                ((IStorableElement)iGridElement).save();
            }
            ++n2;
        }
        iGridElement = (IVirtualOrganization)this.getDefault();
        if (iGridElement != null) {
            Preferences.setDefaultVoName(iGridElement.getName());
            Preferences.save();
        }
    }
}

