/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.model.VirtualGridContainer;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.model.IVirtualOrganization;
import org.eclipse.core.runtime.IProgressMonitor;

public class VoResourceContainer
extends VirtualGridContainer {
    private ResourceType type;
    private IVirtualOrganization vo;

    protected VoResourceContainer(IGridContainer iGridContainer, IVirtualOrganization iVirtualOrganization, ResourceType resourceType) {
        super(iGridContainer, VoResourceContainer.getName(resourceType));
        this.vo = iVirtualOrganization;
        this.type = resourceType;
    }

    public boolean canContain(IGridElement iGridElement) {
        boolean bl = false;
        if (this.type == ResourceType.Computing) {
            bl = iGridElement instanceof IGridComputing;
        } else if (this.type == ResourceType.Service) {
            bl = iGridElement instanceof IGridService;
        } else if (this.type == ResourceType.Storage) {
            bl = iGridElement instanceof IGridStorage;
        }
        return bl;
    }

    public ResourceType getType() {
        return this.type;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isVirtual() {
        return true;
    }

    protected boolean fetchChildren(IProgressMonitor iProgressMonitor) throws GridModelException {
        IGridElement[] iGridElementArray = null;
        IGridInfoService iGridInfoService = this.getVo().getInfoService();
        if (iGridInfoService != null) {
            if (this.type == ResourceType.Service) {
                iGridElementArray = iGridInfoService.fetchServices(this, this.vo, iProgressMonitor);
            } else if (this.type == ResourceType.Computing) {
                iGridElementArray = iGridInfoService.fetchComputing(this, this.vo, iProgressMonitor);
            } else if (this.type == ResourceType.Storage) {
                iGridElementArray = iGridInfoService.fetchStorage(this, this.vo, iProgressMonitor);
            }
        } else if (this.type == ResourceType.Service) {
            iGridElementArray = this.vo.getServices();
        }
        if (iGridElementArray != null) {
            this.lock();
            try {
                IGridElement[] iGridElementArray2 = iGridElementArray;
                int n = iGridElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement iGridElement = iGridElementArray2[n2];
                    this.addElement(iGridElement);
                    ++n2;
                }
            }
            finally {
                this.unlock();
            }
        }
        return true;
    }

    protected IVirtualOrganization getVo() {
        return this.vo;
    }

    private static String getName(ResourceType resourceType) {
        String string = null;
        switch (resourceType) {
            case Computing: {
                string = "Computing";
                break;
            }
            case Storage: {
                string = "Storage";
                break;
            }
            case Service: {
                string = "Services";
            }
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResourceType {
        Computing,
        Storage,
        Service;

    }
}

