/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.VoResourceContainer;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridJobSubmissionService;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IWrappedElement;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class VoWrapper
extends AbstractGridContainer
implements IVirtualOrganization,
IWrappedElement {
    private IGridProject project;
    private IVirtualOrganization vo;

    protected VoWrapper(IGridProject iGridProject, IVirtualOrganization iVirtualOrganization) {
        this.project = iGridProject;
        this.vo = iVirtualOrganization;
        try {
            this.addElement(new VoResourceContainer(this, iVirtualOrganization, VoResourceContainer.ResourceType.Service));
            this.addElement(new VoResourceContainer(this, iVirtualOrganization, VoResourceContainer.ResourceType.Computing));
            this.addElement(new VoResourceContainer(this, iVirtualOrganization, VoResourceContainer.ResourceType.Storage));
        }
        catch (GridModelException gridModelException) {
            Activator.logException((Throwable)((Object)gridModelException));
        }
    }

    public boolean canContain(IGridElement iGridElement) {
        return iGridElement instanceof VoResourceContainer;
    }

    public String getTypeName() {
        return this.vo.getTypeName();
    }

    public void dispose() {
        this.vo.dispose();
    }

    public IGridComputing[] getComputing() throws GridModelException {
        return this.vo.getComputing();
    }

    public IFileStore getFileStore() {
        return this.getProject().getFileStore().getChild(this.getName());
    }

    public IGridInfoService getInfoService() throws GridModelException {
        return this.vo.getInfoService();
    }

    public String getName() {
        return this.vo.getName();
    }

    public IGridContainer getParent() {
        return this.project;
    }

    public IPath getPath() {
        return this.project.getPath().append(this.getName());
    }

    public IGridProject getProject() {
        return this.project;
    }

    public IResource getResource() {
        return null;
    }

    public IGridService[] getServices() throws GridModelException {
        return this.vo.getServices();
    }

    public IGridStorage[] getStorage() throws GridModelException {
        return this.vo.getStorage();
    }

    public IGridJobSubmissionService[] getJobSubmissionServices() throws GridModelException {
        return this.vo.getJobSubmissionServices();
    }

    public IGridElement getWrappedElement() {
        return this.vo;
    }

    public boolean isLazy() {
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    public Object getAdapter(Class clazz) {
        return this.vo.getAdapter(clazz);
    }

    public void load() throws GridModelException {
    }

    public void save() throws GridModelException {
    }

    public void setDirty() {
        try {
            IGridElement[] iGridElementArray = this.getChildren(null);
            int n = iGridElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement iGridElement = iGridElementArray[n2];
                if (iGridElement instanceof IGridContainer) {
                    ((IGridContainer)iGridElement).setDirty();
                }
                ++n2;
            }
        }
        catch (GridModelException gridModelException) {
            Activator.logException((Throwable)((Object)gridModelException));
        }
    }

    public String getWizardId() {
        return this.vo.getWizardId();
    }
}

