/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model.notify;

import eu.geclipse.core.Extensions;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.GridRoot;
import eu.geclipse.core.internal.model.notify.GridModelEvent;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridProject;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class GridElementLifecycleManager
implements IResourceDeltaVisitor {
    public static IGridElementCreator findCreator(IResource iResource) {
        IGridElementCreator iGridElementCreator = null;
        List<IGridElementCreator> list = Extensions.getRegisteredElementCreators();
        for (IGridElementCreator iGridElementCreator2 : list) {
            if (!iGridElementCreator2.canCreate(iResource)) continue;
            iGridElementCreator = iGridElementCreator2;
            break;
        }
        if (iGridElementCreator == null) {
            iGridElementCreator = GridElementLifecycleManager.findStandardCreator(iResource);
        }
        return iGridElementCreator;
    }

    public static IGridElementCreator findStandardCreator(IResource iResource) {
        IGridElementCreator iGridElementCreator = null;
        List<IGridElementCreator> list = GridModel.getStandardCreators();
        for (IGridElementCreator iGridElementCreator2 : list) {
            if (!iGridElementCreator2.canCreate(iResource)) continue;
            iGridElementCreator = iGridElementCreator2;
            break;
        }
        return iGridElementCreator;
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        switch (iResourceDelta.getKind()) {
            case 1: {
                this.resourceAdded(iResourceDelta.getResource());
                break;
            }
            case 2: {
                this.resourceRemoved(iResourceDelta.getResource());
                break;
            }
            case 4: {
                this.resourceChanged(iResourceDelta.getResource(), iResourceDelta.getFlags());
            }
        }
        return true;
    }

    private void projectStateChanged(IGridProject iGridProject) {
        int n = iGridProject.isOpen() ? 3 : 4;
        IGridContainer iGridContainer = iGridProject.getParent();
        IGridElement[] iGridElementArray = new IGridElement[]{iGridProject};
        GridModelEvent gridModelEvent = new GridModelEvent(n, iGridContainer, iGridElementArray);
        GridRoot.getGridNotificationService().queueEvent(gridModelEvent);
    }

    private void resourceAdded(IResource iResource) {
        IGridContainer iGridContainer;
        IContainer iContainer;
        IGridElementCreator iGridElementCreator;
        if (iResource != null && (iGridElementCreator = GridElementLifecycleManager.findCreator(iResource)) != null && (iContainer = iResource.getParent()) != null && (iGridContainer = (IGridContainer)GridRoot.getInstance().findElement((IResource)iContainer)) != null) {
            try {
                iGridContainer.create(iGridElementCreator);
            }
            catch (GridModelException gridModelException) {
                Activator.logException((Throwable)((Object)gridModelException));
            }
        }
    }

    private void resourceChanged(IResource iResource, int n) {
        IGridElement iGridElement;
        if (iResource != null && (iGridElement = GridRoot.getInstance().findElement(iResource)) != null && iGridElement instanceof IGridProject && (n & 0x4000) != 0) {
            this.projectStateChanged((IGridProject)iGridElement);
        }
    }

    private void resourceRemoved(IResource iResource) {
        IGridContainer iGridContainer;
        IGridElement iGridElement;
        if (iResource != null && (iGridElement = GridRoot.getInstance().findElement(iResource)) != null && (iGridContainer = iGridElement.getParent()) != null) {
            try {
                iGridContainer.delete(iGridElement);
            }
            catch (GridModelException gridModelException) {
                Activator.logException((Throwable)((Object)gridModelException));
            }
        }
    }
}

