/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model.notify;

import eu.geclipse.core.internal.model.notify.GridModelEvent;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import java.util.ArrayList;
import java.util.List;

public class GridNotificationService {
    private static GridNotificationService instance;
    private List<IGridModelListener> listeners = new ArrayList<IGridModelListener>();
    private List<IGridModelEvent> eventList = new ArrayList<IGridModelEvent>();
    private int lockCounter = 0;

    private GridNotificationService() {
    }

    public static GridNotificationService getInstance() {
        if (instance == null) {
            instance = new GridNotificationService();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IGridModelListener iGridModelListener) {
        List<IGridModelListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(iGridModelListener)) {
                this.listeners.add(iGridModelListener);
            }
        }
    }

    public void lock() {
        ++this.lockCounter;
    }

    public void queueEvent(IGridModelEvent iGridModelEvent) {
        this.incorporateEvent(iGridModelEvent);
        this.processEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IGridModelListener iGridModelListener) {
        List<IGridModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(iGridModelListener);
        }
    }

    public void unlock() {
        if (this.lockCounter > 0) {
            --this.lockCounter;
            if (this.lockCounter == 0) {
                this.processEvents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incorporateEvent(IGridModelEvent iGridModelEvent) {
        IGridElement iGridElement = iGridModelEvent.getSource();
        int n = iGridModelEvent.getType();
        List<IGridModelEvent> list = this.eventList;
        synchronized (list) {
            int n2 = 0;
            IGridModelEvent iGridModelEvent2 = null;
            while (n2 < this.eventList.size()) {
                iGridModelEvent2 = this.eventList.get(n2);
                if (iGridElement == iGridModelEvent2.getSource() && n == iGridModelEvent2.getType()) break;
                ++n2;
            }
            if (n2 < this.eventList.size() && iGridModelEvent2 != null) {
                Object object;
                IGridElement[] iGridElementArray = iGridModelEvent.getElements();
                IGridElement[] iGridElementArray2 = iGridModelEvent2.getElements();
                ArrayList<IGridElement[]> arrayList = new ArrayList<IGridElement[]>();
                IGridElement[] iGridElementArray3 = iGridElementArray2;
                int n3 = iGridElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    object = iGridElementArray3[n4];
                    arrayList.add((IGridElement[])object);
                    ++n4;
                }
                iGridElementArray3 = iGridElementArray;
                n3 = iGridElementArray.length;
                n4 = 0;
                while (n4 < n3) {
                    object = iGridElementArray3[n4];
                    if (!arrayList.contains(object)) {
                        arrayList.add((IGridElement[])object);
                    }
                    ++n4;
                }
                object = arrayList.toArray(new IGridElement[arrayList.size()]);
                GridModelEvent gridModelEvent = new GridModelEvent(n, iGridElement, (IGridElement[])object);
                this.eventList.remove(n2);
                this.eventList.add(n2, gridModelEvent);
            } else {
                this.eventList.add(iGridModelEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() {
        if (this.lockCounter == 0) {
            ArrayList<IGridModelEvent> arrayList;
            List<IGridModelEvent> object2 = this.eventList;
            synchronized (object2) {
                arrayList = new ArrayList<IGridModelEvent>(this.eventList);
                this.eventList.clear();
            }
            for (IGridModelEvent iGridModelEvent : arrayList) {
                for (IGridModelListener iGridModelListener : this.listeners) {
                    iGridModelListener.gridModelChanged(iGridModelEvent);
                }
            }
        }
    }
}

