/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model.notify;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.GridRoot;
import eu.geclipse.core.internal.model.notify.GridElementLifecycleManager;
import eu.geclipse.core.internal.model.notify.GridNotificationService;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ResourceNotificationService
implements IResourceChangeListener {
    private static ResourceNotificationService instance;

    private ResourceNotificationService() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static ResourceNotificationService getInstance() {
        if (instance == null) {
            instance = new ResourceNotificationService();
        }
        return instance;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta != null) {
            GridNotificationService gridNotificationService = GridRoot.getGridNotificationService();
            gridNotificationService.lock();
            GridElementLifecycleManager gridElementLifecycleManager = new GridElementLifecycleManager();
            try {
                iResourceDelta.accept((IResourceDeltaVisitor)gridElementLifecycleManager);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
            gridNotificationService.unlock();
        }
    }
}

