/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.io;

import eu.geclipse.core.io.PipedOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PipedInputStream
extends InputStream {
    private int bufferSize = 100000;
    private byte[] buffer = new byte[this.bufferSize];
    private int readPos = 0;
    private int writePos = 0;
    private boolean closed = false;

    public PipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        this();
        this.connect(pipedOutputStream);
    }

    public PipedInputStream() {
    }

    public void connect(PipedOutputStream pipedOutputStream) throws IOException {
        pipedOutputStream.connect(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        int n;
        block6: {
            n = -1;
            try {
                if (this.closed) break block6;
                PipedInputStream pipedInputStream = this;
                synchronized (pipedInputStream) {
                    while (this.readPos == this.writePos) {
                        this.notifyAll();
                        this.wait();
                    }
                    n = this.buffer[this.readPos];
                    ++this.readPos;
                    this.readPos %= this.buffer.length;
                    this.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.getLocalizedMessage());
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        if (!this.closed) {
            if (n < 0 || n5 < 0 || n + n2 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n5 == 0) {
                n3 = 0;
            } else {
                PipedInputStream pipedInputStream = this;
                synchronized (pipedInputStream) {
                    byArray[n4] = (byte)this.read();
                    int n7 = Math.min(--n5, this.available());
                    n6 = Math.min(this.buffer.length - this.readPos, n7);
                    System.arraycopy(this.buffer, this.readPos, byArray, ++n4, n6);
                    this.readPos += n6;
                    this.readPos %= this.buffer.length;
                    int n8 = n7 - n6;
                    if (n8 > 0) {
                        System.arraycopy(this.buffer, this.readPos, byArray, n4 += n6, n8);
                        this.readPos += n8;
                        this.readPos %= this.buffer.length;
                    }
                    this.notifyAll();
                    n3 = n7 + 1;
                }
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        int n;
        PipedInputStream pipedInputStream = this;
        synchronized (pipedInputStream) {
            n = (this.bufferSize + this.writePos - this.readPos) % this.bufferSize;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PipedInputStream pipedInputStream = this;
        synchronized (pipedInputStream) {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(int n) throws IOException {
        try {
            PipedInputStream pipedInputStream = this;
            synchronized (pipedInputStream) {
                while (this.readPos == (this.writePos + 1) % this.buffer.length) {
                    this.notifyAll();
                    this.wait();
                }
                this.buffer[this.writePos] = (byte)n;
                ++this.writePos;
                this.writePos %= this.buffer.length;
                this.notifyAll();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            int n3 = n;
            int n4 = n2;
            PipedInputStream pipedInputStream = this;
            synchronized (pipedInputStream) {
                do {
                    int n5;
                    if ((n5 = this.buffer.length - this.available() - 1) > 0) {
                        int n6 = Math.min(n4, n5);
                        int n7 = Math.min(this.buffer.length - this.writePos, n6);
                        System.arraycopy(byArray, n3, this.buffer, this.writePos, n7);
                        n3 += n7;
                        n4 -= n7;
                        this.writePos += n7;
                        this.writePos %= this.buffer.length;
                        continue;
                    }
                    this.notifyAll();
                    this.wait();
                } while (n4 > 0);
                this.notifyAll();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getLocalizedMessage());
        }
    }
}

