/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model;

import eu.geclipse.core.Extensions;
import eu.geclipse.core.internal.model.ConnectionManager;
import eu.geclipse.core.internal.model.GridProjectCreator;
import eu.geclipse.core.internal.model.GridRoot;
import eu.geclipse.core.internal.model.HiddenProject;
import eu.geclipse.core.internal.model.JobManager;
import eu.geclipse.core.internal.model.LocalResourceCreator;
import eu.geclipse.core.internal.model.TransferManager;
import eu.geclipse.core.internal.model.VoManager;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IConnectionManager;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridJobCreator;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridJobManager;
import eu.geclipse.core.model.IGridPreferences;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.core.model.IStorableElementCreator;
import eu.geclipse.core.model.ITransferManager;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IVoManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridModel {
    private static List<IGridElementCreator> standardCreators;

    public static IConnectionManager getConnectionManager() {
        return ConnectionManager.getManager();
    }

    public static IGridJobManager getJobManager() {
        return JobManager.getManager();
    }

    public static IGridRoot getRoot() {
        return GridRoot.getInstance();
    }

    public static List<IGridElementCreator> getStandardCreators() {
        if (standardCreators == null) {
            standardCreators = new ArrayList<IGridElementCreator>();
            standardCreators.add(new GridProjectCreator());
            standardCreators.add(new LocalResourceCreator());
        }
        return standardCreators;
    }

    public static IGridElementCreator getElementCreator(Object object, Class<? extends IGridElement> clazz) {
        IGridElementCreator iGridElementCreator = null;
        List<IGridElementCreator> list = clazz == null ? GridModel.getElementCreators() : GridModel.getElementCreators(clazz);
        for (IGridElementCreator iGridElementCreator2 : list) {
            if (!iGridElementCreator2.canCreate(object)) continue;
            iGridElementCreator = iGridElementCreator2;
            break;
        }
        return iGridElementCreator;
    }

    public static List<IGridElementCreator> getElementCreators() {
        return Extensions.getRegisteredElementCreators();
    }

    public static List<IGridElementCreator> getElementCreators(Class<? extends IGridElement> clazz) {
        ArrayList<IGridElementCreator> arrayList = new ArrayList<IGridElementCreator>();
        List<IGridElementCreator> list = GridModel.getElementCreators();
        for (IGridElementCreator iGridElementCreator : list) {
            if (!iGridElementCreator.canCreate(clazz)) continue;
            arrayList.add(iGridElementCreator);
        }
        return arrayList;
    }

    public static List<IStorableElementCreator> getStorableElementCreators() {
        ArrayList<IStorableElementCreator> arrayList = new ArrayList<IStorableElementCreator>();
        List<IGridElementCreator> list = GridModel.getElementCreators();
        for (IGridElementCreator iGridElementCreator : list) {
            if (!(iGridElementCreator instanceof IStorableElementCreator)) continue;
            arrayList.add((IStorableElementCreator)iGridElementCreator);
        }
        return arrayList;
    }

    public static IStorableElementCreator getStorableElementCreator(IFileStore iFileStore) {
        IStorableElementCreator iStorableElementCreator = null;
        List<IStorableElementCreator> list = GridModel.getStorableElementCreators();
        for (IStorableElementCreator iStorableElementCreator2 : list) {
            if (!iStorableElementCreator2.canCreate(iFileStore)) continue;
            iStorableElementCreator = iStorableElementCreator2;
            break;
        }
        return iStorableElementCreator;
    }

    public static List<IGridJobCreator> getJobCreators() {
        ArrayList<IGridJobCreator> arrayList = new ArrayList<IGridJobCreator>();
        List<IGridElementCreator> list = GridModel.getElementCreators();
        for (IGridElementCreator iGridElementCreator : list) {
            if (!(iGridElementCreator instanceof IGridJobCreator)) continue;
            arrayList.add((IGridJobCreator)iGridElementCreator);
        }
        return arrayList;
    }

    public static List<IGridJobCreator> getJobCreators(IGridJobDescription iGridJobDescription) {
        ArrayList<IGridJobCreator> arrayList = new ArrayList<IGridJobCreator>();
        List<IGridJobCreator> list = GridModel.getJobCreators();
        for (IGridJobCreator iGridJobCreator : list) {
            if (!iGridJobCreator.canCreate(iGridJobDescription)) continue;
            arrayList.add(iGridJobCreator);
        }
        return arrayList;
    }

    public static IGridPreferences getPreferences() throws GridModelException {
        return HiddenProject.getInstance();
    }

    public static ITransferManager getTransferManager() {
        return TransferManager.getManager();
    }

    public static List<IGridElementCreator> getVoCreators() {
        return GridModel.getElementCreators(IVirtualOrganization.class);
    }

    public static IVoManager getVoManager() {
        return VoManager.getManager();
    }
}

