/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.internal.model.GridRoot;
import eu.geclipse.core.internal.model.notify.GridModelEvent;
import eu.geclipse.core.internal.model.notify.GridNotificationService;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.GridModelProblems;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IManageable;
import eu.geclipse.core.model.impl.AbstractGridElement;
import eu.geclipse.core.model.impl.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractGridContainer
extends AbstractGridElement
implements IGridContainer {
    private List<IGridElement> children = new ArrayList<IGridElement>();
    private boolean dirty;

    protected AbstractGridContainer() {
        this.setDirty();
    }

    public boolean canContain(IGridElement iGridElement) {
        return false;
    }

    public boolean contains(IGridElement iGridElement) {
        return this.children.contains(iGridElement);
    }

    public IGridElement create(IGridElementCreator iGridElementCreator) throws GridModelException {
        IGridElement iGridElement = iGridElementCreator.create(this);
        iGridElement = this.addElement(iGridElement);
        return iGridElement;
    }

    public void delete(IGridElement iGridElement) throws GridModelException {
        this.removeElement(iGridElement);
        if (iGridElement instanceof IManageable) {
            IGridElementManager iGridElementManager = ((IManageable)iGridElement).getManager();
            iGridElementManager.removeElement(iGridElement);
        }
        iGridElement.dispose();
    }

    public void dispose() {
        this.deleteAll();
        super.dispose();
    }

    public int getChildCount() {
        int n = this.isLazy() && this.isDirty() ? 1 : this.children.size();
        return n;
    }

    public IGridElement[] getChildren(IProgressMonitor iProgressMonitor) throws GridModelException {
        this.lock();
        try {
            if (this.isLazy() && this.isDirty()) {
                this.deleteAll();
                boolean bl = this.fetchChildren(iProgressMonitor);
                this.setDirty(!bl);
            }
        }
        finally {
            this.unlock();
        }
        return this.children.toArray(new IGridElement[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.isLazy() || !this.children.isEmpty();
    }

    public IGridElement findChild(String string) {
        IGridElement iGridElement = null;
        for (IGridElement iGridElement2 : this.children) {
            if (!iGridElement2.getName().equals(string)) continue;
            iGridElement = iGridElement2;
            break;
        }
        return iGridElement;
    }

    public IGridElement findChildWithResource(String string) {
        IGridElement iGridElement = null;
        for (IGridElement iGridElement2 : this.children) {
            if (iGridElement2.isVirtual() || !iGridElement2.getResource().getName().equals(string)) continue;
            iGridElement = iGridElement2;
            break;
        }
        return iGridElement;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void refresh(IProgressMonitor iProgressMonitor) throws GridModelException {
        block8: {
            this.lock();
            try {
                if (this.isLocal()) {
                    IContainer iContainer = (IContainer)this.getResource();
                    try {
                        iContainer.refreshLocal(2, iProgressMonitor);
                        break block8;
                    }
                    catch (CoreException coreException) {
                        throw new GridModelException(GridModelProblems.REFRESH_FAILED, coreException);
                    }
                }
                this.setDirty();
                try {
                    this.getChildren(iProgressMonitor);
                }
                catch (GridModelException gridModelException) {
                    throw new GridModelException(GridModelProblems.REFRESH_FAILED, (Throwable)((Object)gridModelException));
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    public void setDirty() {
        this.setDirty(true);
    }

    protected IGridElement addElement(IGridElement iGridElement) throws GridModelException {
        if (iGridElement != null) {
            this.testCanContain(iGridElement);
            IGridElement iGridElement2 = this.findChild(iGridElement.getName());
            if (iGridElement2 != null) {
                this.delete(iGridElement2);
            }
            this.children.add(iGridElement);
            GridRoot.registerElement(iGridElement);
            this.fireGridModelEvent(1, iGridElement);
        }
        return iGridElement;
    }

    protected void deleteAll() {
        if (this.children != null && !this.children.isEmpty()) {
            for (IGridElement iGridElementArray2 : this.children) {
                iGridElementArray2.dispose();
            }
            IGridElement[] iGridElementArray = this.children.toArray(new IGridElement[this.children.size()]);
            this.fireGridModelEvent(2, iGridElementArray);
            this.children.clear();
        }
    }

    protected boolean fetchChildren(IProgressMonitor iProgressMonitor) throws GridModelException {
        return true;
    }

    protected void removeElement(IGridElement iGridElement) {
        boolean bl = this.children.remove(iGridElement);
        if (bl) {
            this.fireGridModelEvent(2, iGridElement);
        }
    }

    protected void setDirty(boolean bl) {
        this.dirty = bl;
        if (bl) {
            for (IGridElement iGridElement : this.children) {
                if (!(iGridElement instanceof IGridContainer)) continue;
                ((IGridContainer)iGridElement).setDirty();
            }
        }
    }

    protected void lock() {
        this.getGridNotificationService().lock();
    }

    protected void unlock() {
        this.getGridNotificationService().unlock();
    }

    private void fireGridModelEvent(int n, IGridElement iGridElement) {
        this.fireGridModelEvent(n, new IGridElement[]{iGridElement});
    }

    private void fireGridModelEvent(int n, IGridElement[] iGridElementArray) {
        if (iGridElementArray != null && iGridElementArray.length > 0) {
            GridModelEvent gridModelEvent = new GridModelEvent(n, this, iGridElementArray);
            this.getGridNotificationService().queueEvent(gridModelEvent);
        }
    }

    private GridNotificationService getGridNotificationService() {
        return GridRoot.getGridNotificationService();
    }

    private void testCanContain(IGridElement iGridElement) throws GridModelException {
        if (!this.canContain(iGridElement)) {
            throw new GridModelException(GridModelProblems.CONTAINER_CAN_NOT_CONTAIN, String.format(Messages.getString("AbstractGridContainer.can_not_contain_error"), this.getClass().getName(), iGridElement.getClass().getName()));
        }
    }
}

