/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.VoManager;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.GridModelProblems;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridJobSubmissionService;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class AbstractVirtualOrganization
extends AbstractGridContainer
implements IVirtualOrganization {
    protected AbstractVirtualOrganization() {
    }

    public boolean canContain(IGridElement iGridElement) {
        return iGridElement instanceof IGridService;
    }

    public void dispose() {
        IFileStore iFileStore = this.getFileStore();
        try {
            iFileStore.delete(0, null);
        }
        catch (CoreException coreException) {
            Activator.logException(coreException);
        }
    }

    public IGridComputing[] getComputing() throws GridModelException {
        IGridComputing[] iGridComputingArray = null;
        IGridInfoService iGridInfoService = this.getInfoService();
        if (iGridInfoService != null) {
            iGridComputingArray = iGridInfoService.fetchComputing(this, this, null);
        }
        return iGridComputingArray;
    }

    public IFileStore getFileStore() {
        IFileStore iFileStore = VoManager.getVoManagerStore().getChild(this.getName());
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        if (!iFileInfo.exists()) {
            try {
                iFileStore.mkdir(0, null);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
        }
        return iFileStore;
    }

    public IGridInfoService getInfoService() throws GridModelException {
        IGridElement[] iGridElementArray;
        IGridInfoService iGridInfoService = null;
        IGridElement[] iGridElementArray2 = iGridElementArray = this.getChildren(null);
        int n = iGridElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement iGridElement = iGridElementArray2[n2];
            if (iGridElement instanceof IGridInfoService) {
                iGridInfoService = (IGridInfoService)iGridElement;
                break;
            }
            ++n2;
        }
        return iGridInfoService;
    }

    public IGridContainer getParent() {
        return VoManager.getManager();
    }

    public IPath getPath() {
        Path path = new Path(".vos");
        return path.append(this.getName());
    }

    public IResource getResource() {
        return null;
    }

    public IGridService[] getServices() throws GridModelException {
        IGridService[] iGridServiceArray = null;
        IGridInfoService iGridInfoService = this.getInfoService();
        if (iGridInfoService != null) {
            iGridServiceArray = iGridInfoService.fetchServices(this, this, null);
        }
        return iGridServiceArray;
    }

    public IGridStorage[] getStorage() throws GridModelException {
        IGridStorage[] iGridStorageArray = null;
        IGridInfoService iGridInfoService = this.getInfoService();
        if (iGridInfoService != null) {
            iGridStorageArray = iGridInfoService.fetchStorage(this, this, null);
        }
        return iGridStorageArray;
    }

    public IGridJobSubmissionService[] getJobSubmissionServices() throws GridModelException {
        IGridService[] iGridServiceArray;
        ArrayList<IGridJobSubmissionService> arrayList = new ArrayList<IGridJobSubmissionService>();
        IGridService[] iGridServiceArray2 = iGridServiceArray = this.getServices();
        int n = iGridServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGridService iGridService = iGridServiceArray2[n2];
            if (iGridService instanceof IGridJobSubmissionService) {
                arrayList.add((IGridJobSubmissionService)iGridService);
            }
            ++n2;
        }
        return arrayList.toArray(new IGridJobSubmissionService[arrayList.size()]);
    }

    public boolean isLocal() {
        return true;
    }

    public void load() throws GridModelException {
        this.deleteAll();
        IFileStore iFileStore = this.getFileStore();
        try {
            IFileStore[] iFileStoreArray;
            IFileStore[] iFileStoreArray2 = iFileStoreArray = iFileStore.childStores(0, null);
            int n = iFileStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore iFileStore2 = iFileStoreArray2[n2];
                IGridElement iGridElement = this.loadChild(iFileStore2.getName());
                if (iGridElement != null) {
                    this.addElement(iGridElement);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            throw new GridModelException(GridModelProblems.ELEMENT_LOAD_FAILED, coreException);
        }
    }

    public void save() throws GridModelException {
        IGridElement[] iGridElementArray;
        IGridElement[] iGridElementArray2 = iGridElementArray = this.getChildren(null);
        int n = iGridElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement iGridElement = iGridElementArray2[n2];
            if (iGridElement instanceof IStorableElement) {
                ((IStorableElement)iGridElement).save();
            }
            ++n2;
        }
    }

    protected abstract IGridElement loadChild(String var1);
}

