/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.impl.AbstractVirtualOrganization;
import eu.geclipse.core.model.impl.GenericVoCreator;
import eu.geclipse.core.model.impl.GenericVoProperties;
import org.eclipse.core.filesystem.IFileStore;

public class GenericVirtualOrganization
extends AbstractVirtualOrganization {
    private static final String VO_TYPE_NAME = "Generic VO";
    private String name;

    GenericVirtualOrganization(GenericVoCreator genericVoCreator) {
        try {
            this.apply(genericVoCreator);
        }
        catch (GridModelException gridModelException) {
            Activator.logException((Throwable)((Object)gridModelException));
        }
    }

    GenericVirtualOrganization(IFileStore iFileStore) {
        this.name = iFileStore.getName();
        try {
            this.load();
        }
        catch (GridModelException gridModelException) {
            Activator.logException((Throwable)((Object)gridModelException));
        }
    }

    public boolean canContain(IGridElement iGridElement) {
        return super.canContain(iGridElement) || iGridElement instanceof GenericVoProperties;
    }

    public String getTypeName() {
        return VO_TYPE_NAME;
    }

    public boolean isLazy() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    protected void apply(GenericVoCreator genericVoCreator) throws GridModelException {
        this.name = genericVoCreator.getVoName();
        GenericVoProperties genericVoProperties = new GenericVoProperties(this);
        this.addElement(genericVoProperties);
    }

    protected IGridElement loadChild(String string) {
        GenericVoProperties genericVoProperties = null;
        try {
            if (string.equals(".generic_vo_properties")) {
                GenericVoProperties genericVoProperties2 = new GenericVoProperties(this);
                genericVoProperties2.load();
                genericVoProperties = genericVoProperties2;
            }
        }
        catch (GridModelException gridModelException) {
            Activator.logException((Throwable)((Object)gridModelException));
        }
        return genericVoProperties;
    }

    public String getWizardId() {
        return "eu.geclipse.ui.wizards.GenericVoWizard";
    }
}

