/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.Messages;
import eu.geclipse.core.internal.model.notify.GridElementLifecycleManager;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ResourceGridContainer
extends AbstractGridContainer {
    private IResource resource;

    protected ResourceGridContainer(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        this.resource = iResource;
        this.fetchChildren(null);
    }

    public boolean isLazy() {
        return false;
    }

    public IFileStore getFileStore() {
        URI uRI = this.resource.getLocationURI();
        IFileSystem iFileSystem = EFS.getLocalFileSystem();
        IFileStore iFileStore = iFileSystem.getStore(uRI);
        return iFileStore;
    }

    public final String getName() {
        return this.resource.getName();
    }

    public IGridContainer getParent() {
        IGridContainer iGridContainer = null;
        IPath iPath = this.getPath().removeLastSegments(1);
        IGridElement iGridElement = GridModel.getRoot().findElement(iPath);
        if (iGridElement instanceof IGridContainer) {
            iGridContainer = (IGridContainer)iGridElement;
        }
        return iGridContainer;
    }

    public IPath getPath() {
        return this.resource.getFullPath();
    }

    public IResource getResource() {
        return this.resource;
    }

    public boolean isLocal() {
        return true;
    }

    protected boolean fetchChildren(IProgressMonitor iProgressMonitor) {
        boolean bl;
        IProgressMonitor iProgressMonitor2;
        block11: {
            iProgressMonitor2 = iProgressMonitor != null ? iProgressMonitor : new NullProgressMonitor();
            bl = false;
            this.deleteAll();
            if (this.resource != null && this.resource instanceof IContainer) {
                this.lock();
                try {
                    try {
                        IResource[] iResourceArray = ((IContainer)this.resource).members();
                        iProgressMonitor2.beginTask(Messages.getString("AbstractGridContainer.load_progress"), iResourceArray.length);
                        IResource[] iResourceArray2 = iResourceArray;
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource iResource = iResourceArray2[n2];
                            try {
                                IGridElementCreator iGridElementCreator = this.findCreator(iResource);
                                if (iGridElementCreator != null) {
                                    this.create(iGridElementCreator);
                                }
                                iProgressMonitor2.worked(1);
                                if (iProgressMonitor2.isCanceled()) {
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                Activator.logException(throwable);
                            }
                            ++n2;
                        }
                        bl = true;
                    }
                    catch (CoreException coreException) {
                        Activator.logException(coreException);
                        this.unlock();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    this.unlock();
                    throw throwable;
                }
                this.unlock();
            }
        }
        iProgressMonitor2.done();
        this.setDirty(!bl);
        return bl;
    }

    protected IGridElementCreator findCreator(IResource iResource) {
        return GridElementLifecycleManager.findCreator(iResource);
    }
}

