/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.impl.AbstractGridElement;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class ResourceGridElement
extends AbstractGridElement {
    private IResource resource;

    protected ResourceGridElement(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        this.resource = iResource;
    }

    public IFileStore getFileStore() {
        URI uRI = this.resource.getLocationURI();
        IFileSystem iFileSystem = EFS.getLocalFileSystem();
        IFileStore iFileStore = iFileSystem.getStore(uRI);
        return iFileStore;
    }

    public String getName() {
        return this.resource.getName();
    }

    public IGridContainer getParent() {
        IGridContainer iGridContainer = null;
        IPath iPath = this.getPath().removeLastSegments(1);
        IGridElement iGridElement = GridModel.getRoot().findElement(iPath);
        if (iGridElement instanceof IGridContainer) {
            iGridContainer = (IGridContainer)iGridElement;
        }
        return iGridContainer;
    }

    public IPath getPath() {
        return this.resource.getFullPath();
    }

    public IResource getResource() {
        return this.resource;
    }

    public boolean isLocal() {
        return true;
    }
}

