/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.monitoring;

import eu.geclipse.core.CoreProblems;
import eu.geclipse.core.GridException;
import eu.geclipse.core.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.filesystem.IFileStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridProcess {
    protected int pid = 0;
    protected IFileStore procinfo = null;
    protected Hashtable<String, Integer> values = null;
    private final String[] captions = new String[]{Messages.getString("ProcessStatView.pid"), Messages.getString("ProcessStatView.comm"), Messages.getString("ProcessStatView.state"), Messages.getString("ProcessStatView.ppid"), Messages.getString("ProcessStatView.pgrp"), Messages.getString("ProcessStatView.session"), Messages.getString("ProcessStatView.tty_nr"), Messages.getString("ProcessStatView.tpgid"), Messages.getString("ProcessStatView.flags"), Messages.getString("ProcessStatView.minflt"), Messages.getString("ProcessStatView.cminflt"), Messages.getString("ProcessStatView.majflt"), Messages.getString("ProcessStatView.cmajflt"), Messages.getString("ProcessStatView.utime"), Messages.getString("ProcessStatView.stime"), Messages.getString("ProcessStatView.cutime"), Messages.getString("ProcessStatView.cstime"), Messages.getString("ProcessStatView.priority"), Messages.getString("ProcessStatView.nice"), "", Messages.getString("ProcessStatView.itrealvalue"), Messages.getString("ProcessStatView.starttime"), Messages.getString("ProcessStatView.vsize"), Messages.getString("ProcessStatView.rss"), Messages.getString("ProcessStatView.rlim"), Messages.getString("ProcessStatView.startcode"), Messages.getString("ProcessStatView.endcode"), Messages.getString("ProcessStatView.startstack"), Messages.getString("ProcessStatView.kstkesp"), Messages.getString("ProcessStatView.ksteip"), Messages.getString("ProcessStatView.signal"), Messages.getString("ProcessStatView.blocked"), Messages.getString("ProcessStatView.sigignore"), Messages.getString("ProcessStatView.sigcatch"), Messages.getString("ProcessStatView.wchan"), Messages.getString("ProcessStatView.nswap"), Messages.getString("ProcessStatView.cnswap"), Messages.getString("ProcessStatView.exit_signal"), Messages.getString("ProcessStatView.processor"), Messages.getString("ProcessStatView.rt_priority"), Messages.getString("ProcessStatView.policy"), Messages.getString("ProcessStatView.delayacct_blkio_ticks")};

    public GridProcess(IFileStore iFileStore) {
        if (iFileStore != null && iFileStore.fetchInfo().isDirectory()) {
            String string = iFileStore.getName();
            this.pid = Integer.parseInt(string);
            if (this.pid > 0) {
                this.procinfo = iFileStore;
            }
        }
        this.values = new Hashtable();
    }

    public void update() throws GridException {
        if (this.procinfo != null && this.values != null) {
            this.values.clear();
            IFileStore iFileStore = this.procinfo.getChild("stat");
            if (iFileStore != null) {
                BufferedReader bufferedReader = null;
                StringTokenizer stringTokenizer = null;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(iFileStore.openInputStream(0, null)));
                    stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        this.values.put(this.captions[n++], Integer.valueOf(stringTokenizer.nextToken()));
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = exception.getCause();
                    throw new GridException(CoreProblems.CONNECTION_FAILED, throwable, "Error reading/parsing stat of remote process " + this.pid);
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public Hashtable<String, Integer> getStat() {
        return this.values;
    }
}

