/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.monitoring;

import eu.geclipse.core.CoreProblems;
import eu.geclipse.core.GridException;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.monitoring.GridProcess;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridProcessMonitor {
    protected URI targeturi = null;
    protected IFileStore procfs = null;
    protected IFileSystem currentfs = null;
    protected int updateinterval = 5;
    protected HashSet<Integer> proclist = null;
    private Job updateJob = null;

    public GridProcessMonitor(URI uRI) {
        this.targeturi = uRI;
        this.proclist = new HashSet();
        this.updateJob = new Job(String.valueOf(this.targeturi.getHost()) + " updater"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Status status = new Status(4, "eu.geclipse.core.monitoring", "Fetching running process data from " + GridProcessMonitor.this.targeturi.getHost() + " failed");
                try {
                    if (GridProcessMonitor.this.update(iProgressMonitor)) {
                        status = new Status(0, "eu.geclipse.core.monitoring", "Process data fetched successfully.");
                    }
                }
                catch (GridException gridException) {
                    Activator.logException((Throwable)((Object)gridException));
                }
                return status;
            }
        };
    }

    protected void scheduleUpdate() {
        if (this.updateJob.getState() == 0) {
            this.updateJob.schedule();
        }
    }

    protected void stopUpdate() {
        this.updateJob.cancel();
    }

    synchronized boolean update(IProgressMonitor iProgressMonitor) throws GridException {
        this.procfs = null;
        String[] stringArray = null;
        boolean bl = true;
        iProgressMonitor.beginTask("Fetching data from " + this.targeturi.getHost(), 3);
        if (this.currentfs == null) {
            bl = this.initialize();
        }
        iProgressMonitor.worked(1);
        if (this.currentfs != null) {
            try {
                this.procfs = this.currentfs.getStore(this.targeturi);
                stringArray = this.procfs.childNames(0, iProgressMonitor);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
                bl = false;
            }
            iProgressMonitor.worked(1);
        }
        if (stringArray != null) {
            this.proclist.clear();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                try {
                    this.proclist.add(Integer.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {}
                ++n2;
            }
            iProgressMonitor.worked(1);
        }
        iProgressMonitor.done();
        return bl;
    }

    boolean initialize() throws GridException {
        boolean bl = false;
        if (this.targeturi != null) {
            String string = this.targeturi.getPath();
            if (string == null || string.length() == 0) {
                try {
                    this.targeturi = new URI(this.targeturi.getScheme(), this.targeturi.getUserInfo(), this.targeturi.getHost(), this.targeturi.getPort(), "/proc/", "", "");
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            try {
                this.currentfs = EFS.getFileSystem((String)this.targeturi.getScheme());
                bl = true;
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
                Throwable throwable = coreException.getCause();
                throw new GridException(CoreProblems.CONNECTION_FAILED, throwable, "updating a temporary Connection failed");
            }
        }
        return bl;
    }

    public void setUpdateInterval(int n) {
        if (n >= 0) {
            this.updateinterval = n;
            this.updateJob.schedule((long)this.updateinterval);
        } else {
            this.updateinterval = 0;
        }
    }

    public GridProcess getProcessInfo(int n) {
        IFileStore iFileStore;
        GridProcess gridProcess = null;
        if (n > 0 && this.proclist != null && this.proclist.contains(new Integer(n)) && this.currentfs != null && this.procfs != null && (iFileStore = this.procfs.getChild(new Integer(n).toString())) != null) {
            gridProcess = new GridProcess(iFileStore);
        }
        return gridProcess;
    }

    public HashSet<Integer> getProcessList() {
        if (this.proclist.isEmpty()) {
            this.updateJob.schedule();
            try {
                this.updateJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.proclist;
    }

    public int getUpdateInterval() {
        return this.updateinterval;
    }

    public URI getTarget() {
        return this.targeturi;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof GridProcessMonitor) {
            GridProcessMonitor gridProcessMonitor = (GridProcessMonitor)object;
            bl = this.targeturi.equals(gridProcessMonitor.getTarget());
        }
        return bl;
    }
}

